/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.buckminster.aggregator.util.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriUtils {
    private static final DocumentBuilderFactory s_documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final String s_linkPatternString = "([^?/#][^:\"/]+/?)";
    private static final Pattern s_htmlPattern;
    private static final Pattern s_linkPattern;
    private static final Pattern s_ftpPattern;
    private static final Pattern s_indexPath;
    public static final URI[] EMPTY_URI_ARRAY;

    static {
        s_documentBuilderFactory.setIgnoringComments(true);
        s_documentBuilderFactory.setValidating(false);
        s_documentBuilderFactory.setNamespaceAware(false);
        s_htmlPattern = Pattern.compile("<A\\s+HREF=\"([^?/#][^:\"/]+/?)\"\\s*>[^<]+</A>", 2);
        s_linkPattern = Pattern.compile(s_linkPatternString, 2);
        s_ftpPattern = Pattern.compile("[a-z]+\\s+[0-9]+\\s+(?:(?:[0-9]+:[0-9]+)|(?:[0-9]{4}))\\s+(.+?)(?:([\\r|\\n])|(\\s+->\\s+))", 2);
        s_indexPath = Pattern.compile("^(.*/)?index\\.[a-z][a-z0-9]+$");
        EMPTY_URI_ARRAY = new URI[0];
    }

    public static URI appendTrailingSlash(URI uri) {
        if (!uri.getPath().endsWith("/")) {
            try {
                uri = new URI(uri.getScheme(), uri.getAuthority(), String.valueOf(uri.getPath()) + '/', uri.getQuery(), uri.getFragment());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    /*
     * Unable to fully structure code
     */
    public static URI[] extractHTMLLinks(URI uriToHTML, IProgressMonitor monitor) throws CoreException {
        block9: {
            links = new ArrayList<URI>();
            try {
                buffer = new AccessibleByteArrayOutputStream(8192, 0x200000);
                RepositoryTransport.getInstance().download(uriToHTML, (OutputStream)buffer, monitor);
                try {
                    builder = UriUtils.s_documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new ErrorHandler(){

                        public void error(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        public void fatalError(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        public void warning(SAXParseException ex) throws SAXException {
                        }
                    });
                    source = new InputSource(buffer.getInputStream());
                    source.setSystemId(uriToHTML.toString());
                    document = builder.parse(source);
                    UriUtils.collectLinks(document.getDocumentElement(), uriToHTML, links);
                    break block9;
                }
                catch (SAXException e) {
                    scanner = new Scanner(buffer.getInputStream());
                    parent = UriUtils.appendTrailingSlash(uriToHTML);
                    ** while (scanner.findWithinHorizon((Pattern)UriUtils.s_htmlPattern, (int)0) != null)
                }
lbl-1000:
                // 1 sources

                {
                    mr = scanner.match();
                    UriUtils.addLink(links, parent, mr.group(1));
                    continue;
                }
lbl21:
                // 1 sources

                scanner.close();
            }
            catch (IllegalStateException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (FileNotFoundException e) {
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (IOException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (ParserConfigurationException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (URISyntaxException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
        }
        return links.toArray(new URI[links.size()]);
    }

    public static File getFile(URI uri) throws MalformedURLException {
        if (uri == null) {
            return null;
        }
        String proto = uri.toURL().getProtocol();
        if (proto == null) {
            return new File(uri);
        }
        if ("file".equalsIgnoreCase(proto)) {
            String path = uri.toString().replace("file:", "");
            return new File(path);
        }
        return null;
    }

    public static URI[] list(URI uri, IProgressMonitor monitor) throws CoreException {
        File dir = null;
        try {
            dir = UriUtils.getFile(uri);
        }
        catch (MalformedURLException e) {
            Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
            return EMPTY_URI_ARRAY;
        }
        if (dir != null) {
            File[] list = dir.listFiles();
            if (list == null) {
                return EMPTY_URI_ARRAY;
            }
            int top = list.length;
            if (top == 0) {
                return EMPTY_URI_ARRAY;
            }
            URI[] result = new URI[top];
            while (--top >= 0) {
                URI fileUri;
                File file = list[top];
                result[top] = fileUri = URLUtils.normalizeToURI((String)file.toString(), (boolean)file.isDirectory());
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return result;
        }
        String proto = null;
        try {
            proto = uri.toURL().getProtocol();
        }
        catch (MalformedURLException e) {
            Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
            return EMPTY_URI_ARRAY;
        }
        if (proto.equalsIgnoreCase("ftp") || proto.equalsIgnoreCase("sftp")) {
            ArrayList<URI> result = new ArrayList<URI>();
            Scanner scanner = null;
            try {
                scanner = new Scanner(RepositoryTransport.getInstance().stream(uri, monitor));
                uri = UriUtils.appendTrailingSlash(uri);
                while (scanner.findWithinHorizon(s_ftpPattern, 0) != null) {
                    MatchResult mr = scanner.match();
                    result.add(new URI(uri.getScheme(), uri.getAuthority(), String.valueOf(uri.getPath()) + '/' + mr.group(1), uri.getQuery(), uri.getFragment()));
                }
                URI[] uRIArray = result.toArray(new URI[result.size()]);
                return uRIArray;
            }
            catch (CoreException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (FileNotFoundException e) {
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (IOException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (URISyntaxException e) {
                Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return UriUtils.extractHTMLLinks(uri, monitor);
    }

    private static void addLink(List<URI> links, URI parent, String link) throws URISyntaxException {
        Matcher m = s_indexPath.matcher(link.toString());
        if (m.matches() && (link = m.group(1)) == null) {
            return;
        }
        if (link.equals("../")) {
            return;
        }
        links.add(new URI(parent.getScheme(), parent.getAuthority(), String.valueOf(parent.getPath()) + link, parent.getQuery(), parent.getFragment()));
    }

    private static void collectLinks(Element element, URI parent, ArrayList<URI> links) throws URISyntaxException {
        if (element.getNodeName().equals("a")) {
            String link = element.getAttribute("href");
            if (s_linkPattern.matcher(link).matches()) {
                UriUtils.addLink(links, parent, link);
            }
        } else {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    UriUtils.collectLinks((Element)child, parent, links);
                }
                child = child.getNextSibling();
            }
        }
    }
}

