/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.fetcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.buckminster.fetcher.IResourceFetcher;
import org.eclipse.buckminster.fetcher.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.util.Base64;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractResourceFetcher
implements IResourceFetcher {
    private final URL m_url;
    private final String m_destinationDir;
    private String m_login;
    private String m_password;

    public AbstractResourceFetcher(URL url, String dir) {
        this.m_url = url;
        this.m_destinationDir = dir;
    }

    public void fetch(IProgressMonitor monitor) throws IOException, CoreException {
        URLConnection conn = null;
        InputStream in = null;
        try {
            conn = this.m_url.openConnection();
            if (this.m_login != null) {
                String userPassword = String.valueOf(this.m_login) + ':' + this.m_password;
                String encoding = Base64.encode((byte[])userPassword.getBytes());
                conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            in = conn.getInputStream();
            monitor.subTask(NLS.bind((String)Messages.preparing_destination_folder_0, (Object)this.m_destinationDir));
            this.prepareDirectories(this.m_destinationDir);
            monitor.subTask(NLS.bind((String)Messages.fetching_0, (Object)this.getUrl().toString()));
            this.consume(new BufferedInputStream(in), monitor);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setBasicAuthCredential(String login, String password) {
        if (login == null || password == null) {
            throw new NullPointerException(Messages.login_and_password_must_be_not_null);
        }
        this.m_login = login;
        this.m_password = password;
    }

    protected abstract void consume(InputStream var1, IProgressMonitor var2) throws IOException, CoreException;

    protected final String getDestinationDir() {
        return this.m_destinationDir;
    }

    protected URL getUrl() {
        return this.m_url;
    }

    private final void prepareDirectories(String dir) {
        new File(dir).mkdirs();
    }
}

