/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.fetcher.actor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.helpers.PropertyExpander;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.fetcher.IResourceFetcher;
import org.eclipse.buckminster.fetcher.Messages;
import org.eclipse.buckminster.fetcher.StreamProcessorFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetcherActor
extends AbstractActor {
    private static final String INCLUDE = "include=";
    private static final String FETCHER_URL = "url";
    private static final String FETCHER_TO_DIR = "dir";
    private static final String FETCHER_OPTIONS = "options";
    private static final String FETCHER_UNCOMPRESS = "uncompress";
    private static final String FETCHER_FLATTEN = "flatten";
    private static final String FETCHER_LOGIN = "login";
    private static final String FETCHER_PASSWORD = "pass";
    private static final String[] validProperties = new String[]{"url", "dir", "options", "login", "pass"};
    private static final String[] validOptions = new String[]{"flatten", "uncompress"};
    private static final String PLUGIN_ID = "org.eclipse.buckminster.fetcher";
    private PropertyExpander m_expander;

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        try {
            try {
                this.m_expander = new PropertyExpander(ctx);
                this.checkProperties();
                monitor.beginTask(null, 1);
                IResourceFetcher resourceFetcher = this.getResourceFetcher();
                String login = this.getSafeProperty(FETCHER_LOGIN);
                String password = this.getSafeProperty(FETCHER_PASSWORD);
                if (login != null && password != null) {
                    resourceFetcher.setBasicAuthCredential(login, password);
                }
                resourceFetcher.fetch(monitor);
            }
            catch (IOException e) {
                Throwable t = BuckminsterException.unwind((Throwable)e);
                CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
                Status status = new Status(4, PLUGIN_ID, e.getMessage());
                monitor.done();
                return status;
            }
            catch (CoreException e) {
                Throwable t = BuckminsterException.unwind((Throwable)e);
                CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
                throw e;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void checkProperties() throws CoreException {
        HashSet<String> validSet = new HashSet<String>(Arrays.asList(validProperties));
        Map actorProperties = FetcherActor.getActiveContext().getAction().getActorProperties();
        Set keySet = actorProperties.keySet();
        for (String property : keySet) {
            if (validSet.contains(property)) continue;
            StringBuffer buffer = new StringBuffer();
            for (String validProperty : validSet) {
                buffer.append(validProperty).append(' ');
            }
            throw new IllegalStateException(NLS.bind((String)Messages.actorProperty_0_invalid_valid_are_1, (Object)property, (Object)buffer.toString()));
        }
        validSet.clear();
        validSet.addAll(Arrays.asList(validOptions));
        HashSet<String> options = this.getOptions();
        for (String option : options) {
            if (validSet.contains(option) || option.startsWith(INCLUDE)) continue;
            StringBuffer buffer = new StringBuffer();
            for (String validProperty : validSet) {
                buffer.append(validProperty).append(' ');
            }
            buffer.append(INCLUDE);
            throw new IllegalStateException(NLS.bind((String)Messages.actorProperty_option_0_invalid_valid_are_1, (Object)option, (Object)buffer.toString()));
        }
    }

    private String getDestinationDirectory() throws CoreException {
        String homePath = (String)FetcherActor.getActiveContext().getProperties().get("buckminster.home");
        String toDir = this.getSafeProperty(FETCHER_TO_DIR);
        if (toDir == null) {
            return homePath;
        }
        if (new File(toDir).isAbsolute()) {
            return toDir;
        }
        return String.valueOf(homePath) + toDir + File.separatorChar;
    }

    private List<String> getIncludes() throws CoreException {
        ArrayList<String> includes = new ArrayList<String>();
        HashSet<String> options = this.getOptions();
        for (String option : options) {
            if (!option.startsWith(INCLUDE)) continue;
            int start = option.indexOf(61);
            includes.add(option.substring(start + 1));
        }
        return includes;
    }

    private String getLocalFileNameFromUrl(URL url) {
        return new File(url.getFile()).getName();
    }

    private HashSet<String> getOptions() throws CoreException {
        String[] split;
        HashSet<String> options = new HashSet<String>();
        String optionActorProperty = this.getSafeProperty(FETCHER_OPTIONS);
        if (optionActorProperty == null) {
            return options;
        }
        String[] stringArray = split = optionActorProperty.split(";");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            options.add(option);
            ++n2;
        }
        return options;
    }

    private IResourceFetcher getResourceFetcher() throws MalformedURLException, CoreException {
        URL url = this.getUrl();
        String destinationDirectory = this.getDestinationDirectory();
        if (this.shouldUncompress()) {
            return StreamProcessorFactory.getUncompressInstance(url, destinationDirectory, this.getIncludes(), this.shouldFlatten());
        }
        String localFileName = this.getLocalFileNameFromUrl(url);
        return StreamProcessorFactory.getCopyInstance(url, destinationDirectory, localFileName);
    }

    private final String getSafeProperty(String property) throws CoreException {
        String p = TextUtils.notEmptyTrimmedString((String)this.getActorProperty(property));
        if (p == null) {
            return null;
        }
        return this.m_expander.expand(p);
    }

    private URL getUrl() throws MalformedURLException, CoreException {
        return new URL(this.getSafeProperty(FETCHER_URL));
    }

    private boolean hasOption(String option) throws CoreException {
        return this.getOptions().contains(option);
    }

    private boolean shouldFlatten() throws CoreException {
        return this.hasOption(FETCHER_FLATTEN);
    }

    private boolean shouldUncompress() throws CoreException {
        return this.hasOption(FETCHER_UNCOMPRESS);
    }
}

