/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.InstallableUnitReference;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.buckminster.aggregator.provider.ContributionItemProvider;
import org.eclipse.buckminster.aggregator.util.AggregatorResource;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.buckminster.aggregator.util.InstallableUnitUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitReferenceItemProvider
extends AggregatorItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    protected static InstallableUnit getInstallableUnit(InstallableUnitReference iuRef) {
        return iuRef.getInstallableUnit(iuRef.isBranchEnabled() && !iuRef.isMappedRepositoryBroken());
    }

    public InstallableUnitReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getForeground(Object object) {
        return !((InstallableUnitReference)object).isBranchDisabledOrMappedRepositoryBroken() ? null : IItemColorProvider.GRAYED_OUT_COLOR;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addInstallableUnitPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public ResourceLocator getResourceLocator() {
        return AggregatorEditPlugin.INSTANCE;
    }

    public String getText(Object object) {
        return this.getString("_UI_InstallableUnitReference_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(InstallableUnitReference.class)) {
            case 4: {
                ((AggregatorResource)((EObject)notification.getNotifier()).eResource()).analyzeResource();
            }
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void addInstallableUnitPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ContributionItemProvider.DynamicItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_InstallableUnitReference_installableUnit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_InstallableUnitReference_installableUnit_feature", "_UI_InstallableUnitReference_type"), (EStructuralFeature)AggregatorPackage.Literals.INSTALLABLE_UNIT_REFERENCE__INSTALLABLE_UNIT, true, false, false, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                InstallableUnitReference self = (InstallableUnitReference)object;
                MappedRepository container = (MappedRepository)((EObject)self).eContainer();
                MetadataRepository repo = container.getMetadataRepository();
                if (repo == null) {
                    return Collections.singleton(null);
                }
                Collector collector = repo.query(InstallableUnitReferenceItemProvider.this.getInstallableUnitQuery(), new Collector(), null);
                if (collector.isEmpty()) {
                    return Collections.singleton(null);
                }
                ArrayList<InstallableUnit> result = new ArrayList<InstallableUnit>();
                result.add(null);
                Collection availableUnits = collector.toCollection();
                if (self.getInstallableUnit() != null && !availableUnits.contains(self.getInstallableUnit())) {
                    result.add(self.getInstallableUnit());
                }
                result.addAll(availableUnits);
                for (InstallableUnitReference installableUnitReference : InstallableUnitReferenceItemProvider.this.getContainerChildren(container)) {
                    int idx;
                    InstallableUnit iu;
                    if (installableUnitReference == self || (iu = installableUnitReference.getInstallableUnit()) == null || (idx = result.indexOf(iu)) < 0) continue;
                    result.remove(idx);
                }
                Collections.sort(result, InstallableUnitImpl.SELECTION_COMPARATOR);
                return result;
            }
        });
    }

    protected boolean appendIUText(Object iuRef, StringBuilder bld) {
        InstallableUnit iu = InstallableUnitReferenceItemProvider.getInstallableUnit((InstallableUnitReference)iuRef);
        String id = null;
        Version version = null;
        String name = null;
        if (iu != null) {
            id = Trivial.trim((String)iu.getId());
            if (id == null) {
                VersionedName vn = InstallableUnitUtils.getVersionedNameFromProxy((InstallableUnit)iu);
                if (vn != null) {
                    id = vn.getId();
                    version = vn.getVersion();
                }
                name = "missing";
            } else {
                version = iu.getVersion();
                name = GeneralUtils.getLocalizedProperty((InstallableUnit)iu, (String)"org.eclipse.equinox.p2.name");
                if (name != null && name.startsWith("%")) {
                    name = null;
                }
            }
        }
        if (id == null) {
            bld.append("not mapped");
            return false;
        }
        if (id.endsWith(".feature.group")) {
            id = id.substring(0, id.length() - ".feature.group".length());
        }
        bld.append(id);
        bld.append(" / ");
        bld.append(GeneralUtils.stringifyVersion((Version)version));
        if (name != null) {
            bld.append(" (");
            bld.append(name);
            bld.append(")");
        }
        return true;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    protected List<? extends InstallableUnitReference> getContainerChildren(MappedRepository container) {
        throw new UnsupportedOperationException();
    }

    protected Query getInstallableUnitQuery() {
        throw new UnsupportedOperationException();
    }
}

