/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorPackage;
import org.eclipse.buckminster.aggregator.AggregatorPlugin;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.CustomCategory;
import org.eclipse.buckminster.aggregator.Feature;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.MetadataRepositoryReference;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.StatusProvider;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.buckminster.aggregator.provider.ContributionItemProvider;
import org.eclipse.buckminster.aggregator.util.ResourceUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryReferenceItemProvider
extends AggregatorItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public MetadataRepositoryReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getFont(Object object) {
        return ((StatusProvider)object).getStatus().getCode() == StatusCode.WAITING ? IItemFontProvider.ITALIC_FONT : null;
    }

    @Override
    public Object getForeground(Object object) {
        return ((MetadataRepositoryReference)object).isBranchEnabled() ? null : IItemColorProvider.GRAYED_OUT_COLOR;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MetadataRepositoryReference" + (((MetadataRepositoryReference)object).isBranchEnabled() ? "" : "Disabled")));
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addEnabledPropertyDescriptor(object);
            this.addLocationPropertyDescriptor(object);
            this.addNaturePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public ResourceLocator getResourceLocator() {
        return AggregatorEditPlugin.INSTANCE;
    }

    public String getText(Object object) {
        MetadataRepositoryReference repoRef = (MetadataRepositoryReference)object;
        MetadataRepository mdr = repoRef.getMetadataRepository(repoRef.isBranchEnabled());
        StringBuilder bld = new StringBuilder();
        bld.append(this.getString(this.getTypeName()));
        bld.append(' ');
        if (mdr != null) {
            URI location;
            String name;
            String nature = repoRef.getNature();
            if (!((EObject)mdr).eIsProxy()) {
                name = mdr.getName();
                location = mdr.getLocation();
            } else {
                name = mdr.getNameFromProxy();
                location = mdr.getLocationFromProxy();
            }
            if (location != null) {
                bld.append(nature);
                bld.append(':');
                bld.append(location);
            } else {
                bld.append("no location");
            }
            if (name != null) {
                bld.append(" (");
                bld.append(name);
                bld.append(')');
            }
        } else if (repoRef.getLocation() != null) {
            bld.append(repoRef.getNature());
            bld.append(':');
            bld.append(repoRef.getLocation());
            bld.append(" (");
            bld.append(repoRef.getStatus().getCode() == StatusCode.WAITING ? "loading" : "missing");
            bld.append(')');
        } else {
            bld.append("no location");
        }
        return bld.toString();
    }

    public void notifyChanged(Notification notification) {
        this.notifyChangedGen(notification);
        if (notification.getEventType() != 1) {
            return;
        }
        MetadataRepositoryReference repoRef = (MetadataRepositoryReference)notification.getNotifier();
        switch (notification.getFeatureID(MetadataRepositoryReference.class)) {
            case 6: 
            case 7: {
                if (notification.getNewStringValue() != null && !notification.getNewStringValue().equals(notification.getOldStringValue()) || notification.getOldStringValue() != null && !notification.getOldStringValue().equals(notification.getNewStringValue())) {
                    this.onLocationChange(repoRef);
                    return;
                }
            }
            case 0: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)repoRef, true, false));
                HashSet<Object> affectedNodeLabels = new HashSet<Object>();
                affectedNodeLabels.add(repoRef);
                EObject container = ((EObject)repoRef).eContainer();
                affectedNodeLabels.add(((EObject)repoRef).eResource());
                while (container != null) {
                    affectedNodeLabels.add(container);
                    container = container.eContainer();
                }
                if (repoRef instanceof MappedRepository) {
                    HashSet<EObject> hashSet = new HashSet<EObject>();
                    for (MappedUnit unit : ((MappedRepository)repoRef).getUnits(true)) {
                        hashSet.add((EObject)unit);
                        if (!(unit instanceof Feature)) continue;
                        for (CustomCategory category : ((Feature)unit).getCategories()) {
                            hashSet.add((EObject)category);
                        }
                    }
                    for (EObject affectedNode : hashSet) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)affectedNode, true, true));
                    }
                }
                for (Object e : affectedNodeLabels) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, e, false, true));
                }
                Aggregator aggregator = repoRef.getAggregator();
                if (notification.getFeatureID(MetadataRepositoryReference.class) == 0) {
                    if (notification.getNewBooleanValue()) {
                        ResourceUtils.loadResourceForMappedRepository((MetadataRepositoryReference)repoRef);
                        break;
                    }
                    ResourceUtils.cleanUpResources((Aggregator)aggregator);
                    break;
                }
                ResourceUtils.cleanUpResources((Aggregator)aggregator);
            }
        }
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MetadataRepositoryReference.class)) {
            case 0: 
            case 6: 
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void addEnabledPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EnabledStatusProvider_enabled_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_EnabledStatusProvider_enabled_feature", "_UI_EnabledStatusProvider_type"), (EStructuralFeature)AggregatorPackage.Literals.ENABLED_STATUS_PROVIDER__ENABLED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MetadataRepositoryReference_location_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MetadataRepositoryReference_location_feature", "_UI_MetadataRepositoryReference_type"), (EStructuralFeature)AggregatorPackage.Literals.METADATA_REPOSITORY_REFERENCE__LOCATION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addMetadataRepositoryPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ContributionItemProvider.DynamicItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MetadataRepositoryReference_metadataRepository_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MetadataRepositoryReference_metadataRepository_feature", "_UI_MetadataRepositoryReference_type"), (EStructuralFeature)AggregatorPackage.Literals.METADATA_REPOSITORY_REFERENCE__METADATA_REPOSITORY, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                MetadataRepositoryReference self = (MetadataRepositoryReference)object;
                Aggregator aggregator = self.getAggregator();
                Collection repos = super.getChoiceOfValues(object);
                for (Contribution contribution : aggregator.getContributions()) {
                    for (MappedRepository mappedRepo : contribution.getRepositories()) {
                        MetadataRepository repo;
                        if (mappedRepo == self || (repo = mappedRepo.getMetadataRepository()) == null) continue;
                        repos.remove(repo);
                    }
                }
                for (MetadataRepositoryReference mrRef : aggregator.getValidationRepositories()) {
                    MetadataRepository repo;
                    if (mrRef == self || (repo = mrRef.getMetadataRepository()) == null) continue;
                    repos.remove(repo);
                }
                return repos;
            }
        });
    }

    protected void addNaturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MetadataRepositoryReference_nature_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MetadataRepositoryReference_nature_feature", "_UI_MetadataRepositoryReference_type"), (EStructuralFeature)AggregatorPackage.Literals.METADATA_REPOSITORY_REFERENCE__NATURE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                MappedRepository repo = (MappedRepository)object;
                String currentValue = repo.getNature();
                ArrayList supportedValues = AggregatorPlugin.getPlugin().getSupportedRepositoryNatureList();
                if (!supportedValues.contains(currentValue)) {
                    ArrayList globallySupportedValues = supportedValues;
                    supportedValues = new ArrayList(globallySupportedValues.size() + 1);
                    supportedValues.addAll(globallySupportedValues);
                    supportedValues.add(currentValue);
                    Collections.sort(supportedValues);
                }
                return supportedValues;
            }
        });
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    protected String getTypeName() {
        return "_UI_MetadataRepositoryReference_type";
    }

    private void onLocationChange(MetadataRepositoryReference repository) {
        repository.startRepositoryLoad(false);
    }
}

