/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.util.ItemUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToContributionCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private Contribution m_contribution;
    private List<MetadataRepository> m_selectedMDRs;
    private List<InstallableUnit> m_selectedIUs;
    private List<MappedRepository> m_addedMappedRepos = new ArrayList<MappedRepository>();
    private List<MappedUnit> m_addedMappedUnits = new ArrayList<MappedUnit>();

    public AddIUsToContributionCommand(Contribution contribution, List<MetadataRepository> selectedMDRs, List<InstallableUnit> selectedIUs) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Map_to_command_prefix")) + " " + (contribution.getLabel() == null || contribution.getLabel().length() == 0 ? String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Contribution_type")) + " ''" : String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Contribution_type")) + " " + contribution.getLabel()));
        this.m_contribution = contribution;
        this.m_selectedMDRs = selectedMDRs;
        this.m_selectedIUs = selectedIUs;
    }

    public void execute() {
        this.m_addedMappedRepos.clear();
        this.m_addedMappedUnits.clear();
        for (MetadataRepository mdr : this.m_selectedMDRs) {
            MappedRepository newMappedRepo = ItemUtils.addMDR(this.m_contribution, mdr);
            if (newMappedRepo == null) continue;
            this.m_addedMappedRepos.add(newMappedRepo);
        }
        for (InstallableUnit iu : this.m_selectedIUs) {
            MappedUnit newMU;
            MappedRepository newMappedRepo;
            if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                return;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.m_contribution, mdr);
            if (mappedRepo == null && (newMappedRepo = ItemUtils.addMDR(this.m_contribution, mdr)) != null) {
                this.m_addedMappedRepos.add(newMappedRepo);
                mappedRepo = newMappedRepo;
            }
            if ((newMU = ItemUtils.addIU(mappedRepo, iu)) == null) continue;
            this.m_addedMappedUnits.add(newMU);
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (MappedUnit unit : this.m_addedMappedUnits) {
            MappedRepository repo = (MappedRepository)((EObject)unit).eContainer();
            repo.removeUnit(unit);
        }
        this.m_contribution.getRepositories().removeAll(this.m_addedMappedRepos);
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }

    protected boolean prepare() {
        boolean result;
        boolean bl = result = this.m_contribution != null && this.m_contribution.isEnabled() && (this.m_selectedMDRs != null && this.m_selectedMDRs.size() > 0 || this.m_selectedIUs != null && this.m_selectedIUs.size() > 0);
        if (result) {
            for (InstallableUnit iu : this.m_selectedIUs) {
                if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                    return false;
                }
                MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
                MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.m_contribution, mdr);
                if (mappedRepo == null || ItemUtils.findMappedUnit(mappedRepo, iu) == null && ItemUtils.findMapRule(mappedRepo, iu) == null) continue;
                return false;
            }
        }
        return result;
    }
}

