/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.CustomCategory;
import org.eclipse.buckminster.aggregator.Feature;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.util.ItemUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToCustomCategoryCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private CustomCategory m_customCategory;
    private Map<InstallableUnit, MappedRepository> m_mapFeatureMappedRepo = new HashMap<InstallableUnit, MappedRepository>();
    private List<InstallableUnit> m_selectedFeatures;
    private List<Feature> m_featuresAddedToCustomCategory = new ArrayList<Feature>();
    private Map<MappedRepository, List<MappedUnit>> m_unitsAddedToMappedRepo = new HashMap<MappedRepository, List<MappedUnit>>();

    public AddIUsToCustomCategoryCommand(CustomCategory category, List<InstallableUnit> selectedFeatures) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Add_to_command_prefix")) + " " + (category.getLabel() == null || category.getLabel().length() == 0 ? String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Category_type")) + " ''" : String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Category_type")) + " " + category.getLabel()));
        this.m_customCategory = category;
        this.m_selectedFeatures = selectedFeatures;
    }

    public void execute() {
        this.m_featuresAddedToCustomCategory.clear();
        this.m_unitsAddedToMappedRepo.clear();
        for (InstallableUnit feature : this.m_selectedFeatures) {
            MappedRepository repo = this.m_mapFeatureMappedRepo.get(feature);
            if (!repo.isEnabled()) continue;
            MappedUnit unit = ItemUtils.findMappedUnit(repo, feature);
            if (unit == null) {
                unit = AggregatorFactory.eINSTANCE.createMappedUnit(feature);
                repo.addUnit(unit);
                List<MappedUnit> units = this.m_unitsAddedToMappedRepo.get(repo);
                if (units == null) {
                    units = new ArrayList<MappedUnit>();
                    this.m_unitsAddedToMappedRepo.put(repo, units);
                }
                units.add(unit);
            } else if (!unit.isEnabled()) continue;
            if (!(unit instanceof Feature)) continue;
            this.m_customCategory.getFeatures().add((Object)((Feature)unit));
            this.m_featuresAddedToCustomCategory.add((Feature)unit);
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.m_customCategory.getFeatures().removeAll(this.m_featuresAddedToCustomCategory);
        for (MappedRepository mappedRepo : this.m_unitsAddedToMappedRepo.keySet()) {
            for (MappedUnit unit : this.m_unitsAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.removeUnit(unit);
            }
        }
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }

    protected boolean prepare() {
        Aggregator aggregator = (Aggregator)((EObject)this.m_customCategory).eContainer();
        for (InstallableUnit feature : this.m_selectedFeatures) {
            if (!(((EObject)feature).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)feature).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(aggregator, mdr);
            if (mappedRepo == null) continue;
            this.m_mapFeatureMappedRepo.put(feature, mappedRepo);
            if (ItemUtils.findMapRule(mappedRepo, feature) == null) continue;
            return false;
        }
        return this.m_customCategory != null && this.m_selectedFeatures != null && this.m_selectedFeatures.size() > 0 && this.isEnabled();
    }

    private boolean isEnabled() {
        for (InstallableUnit feature : this.m_mapFeatureMappedRepo.keySet()) {
            MappedRepository repo = this.m_mapFeatureMappedRepo.get(feature);
            if (repo == null) {
                return false;
            }
            MappedUnit unit = ItemUtils.findMappedUnit(repo, feature);
            if ((unit == null || unit.isEnabled()) && (unit != null || repo == null || repo.isEnabled())) continue;
            return false;
        }
        return true;
    }
}

