/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.buckminster.aggregator.ExclusionRule;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.ValidConfigurationsRule;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.util.ItemUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToMappedRepositoryCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private MappedRepository m_mappedRepo;
    private List<InstallableUnit> m_selectedIUs;
    private int m_operation;
    private List<MappedUnit> m_addedMappedUnits = new ArrayList<MappedUnit>();
    private List<MapRule> m_addedMapRules = new ArrayList<MapRule>();

    public AddIUsToMappedRepositoryCommand(MappedRepository mappedRepo, List<InstallableUnit> selectedIUs) {
        this(mappedRepo, selectedIUs, 32);
    }

    public AddIUsToMappedRepositoryCommand(MappedRepository mappedRepo, List<InstallableUnit> selectedIUs, int operation) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Map_to_command_prefix")) + " " + AggregatorEditPlugin.INSTANCE.getString("_UI_MappedRepository_type") + " " + mappedRepo.getLocation());
        this.m_mappedRepo = mappedRepo;
        this.m_selectedIUs = selectedIUs;
        this.m_operation = operation;
    }

    public void execute() {
        block3: {
            block2: {
                this.m_addedMappedUnits.clear();
                this.m_addedMapRules.clear();
                if ((this.m_operation & 0x20) <= 0) break block2;
                for (InstallableUnit iu : this.m_selectedIUs) {
                    MappedUnit newMU = ItemUtils.addIU(this.m_mappedRepo, iu);
                    if (newMU == null) continue;
                    this.m_addedMappedUnits.add(newMU);
                }
                break block3;
            }
            if ((this.m_operation & 0xC0) <= 0) break block3;
            for (InstallableUnit iu : this.m_selectedIUs) {
                MapRule newMR = ItemUtils.addMapRule(this.m_mappedRepo, iu, (this.m_operation & 0x40) > 0 ? ExclusionRule.class : ValidConfigurationsRule.class);
                if (newMR == null) continue;
                this.m_addedMapRules.add(newMR);
            }
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        MappedRepository repo;
        for (MappedUnit unit : this.m_addedMappedUnits) {
            repo = (MappedRepository)((EObject)unit).eContainer();
            repo.removeUnit(unit);
        }
        for (MapRule rule : this.m_addedMapRules) {
            repo = (MappedRepository)((EObject)rule).eContainer();
            repo.getMapRules().remove((Object)rule);
        }
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }

    protected boolean prepare() {
        boolean result;
        boolean bl = result = this.m_mappedRepo != null && this.m_mappedRepo.isBranchEnabled() && this.m_selectedIUs != null && this.m_selectedIUs.size() > 0 && ItemUtils.haveSameLocation(this.m_mappedRepo, this.m_selectedIUs);
        if (result) {
            for (InstallableUnit iu : this.m_selectedIUs) {
                if (ItemUtils.findMappedUnit(this.m_mappedRepo, iu) == null && ItemUtils.findMapRule(this.m_mappedRepo, iu) == null) continue;
                return false;
            }
        }
        return result;
    }
}

