/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.ExclusionRule;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.ValidConfigurationsRule;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.buckminster.aggregator.util.ItemUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToParentRepositoryCommand
extends AbstractCommand {
    private Aggregator m_aggregator;
    private List<InstallableUnit> m_selectedIUs;
    private int m_operation;
    private Map<InstallableUnit, MappedRepository> m_mapIUMappedRepo = new HashMap<InstallableUnit, MappedRepository>();
    private Map<MappedRepository, List<MappedUnit>> m_unitsAddedToMappedRepo = new HashMap<MappedRepository, List<MappedUnit>>();
    private Map<MappedRepository, List<MapRule>> m_rulesAddedToMappedRepo = new HashMap<MappedRepository, List<MapRule>>();

    public AddIUsToParentRepositoryCommand(Aggregator aggregator, List<InstallableUnit> selectedIUs, int operation) {
        super(AggregatorEditPlugin.INSTANCE.getString("_UI_Add_to_parent_Mapped_Repository"));
        this.m_aggregator = aggregator;
        this.m_selectedIUs = selectedIUs;
        this.m_operation = operation;
    }

    public void execute() {
        this.m_unitsAddedToMappedRepo.clear();
        this.m_rulesAddedToMappedRepo.clear();
        for (InstallableUnit iu : this.m_selectedIUs) {
            MapRule rule;
            MappedRepository repo = this.m_mapIUMappedRepo.get(iu);
            if (!repo.isEnabled()) continue;
            if ((this.m_operation & 0x20) > 0) {
                MappedUnit unit = ItemUtils.findMappedUnit(repo, iu);
                if (unit != null) continue;
                unit = AggregatorFactory.eINSTANCE.createMappedUnit(iu);
                repo.addUnit(unit);
                List<MappedUnit> units = this.m_unitsAddedToMappedRepo.get(repo);
                if (units == null) {
                    units = new ArrayList<MappedUnit>();
                    this.m_unitsAddedToMappedRepo.put(repo, units);
                }
                units.add(unit);
                continue;
            }
            if ((this.m_operation & 0xC0) <= 0 || (rule = ItemUtils.findMapRule(repo, iu)) != null) continue;
            rule = AggregatorFactory.eINSTANCE.createMapRule(iu, (this.m_operation & 0x40) > 0 ? ExclusionRule.class : ValidConfigurationsRule.class);
            repo.getMapRules().add((Object)rule);
            List<MapRule> rules = this.m_rulesAddedToMappedRepo.get(repo);
            if (rules == null) {
                rules = new ArrayList<MapRule>();
                this.m_rulesAddedToMappedRepo.put(repo, rules);
            }
            rules.add(rule);
        }
    }

    public void redo() {
        for (MappedRepository mappedRepo : this.m_unitsAddedToMappedRepo.keySet()) {
            for (MappedUnit unit : this.m_unitsAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.removeUnit(unit);
            }
            for (MapRule rule : this.m_rulesAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.getMapRules().remove((Object)rule);
            }
        }
    }

    protected boolean prepare() {
        boolean someEnabled = false;
        for (InstallableUnit iu : this.m_selectedIUs) {
            if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.m_aggregator, mdr);
            if (mappedRepo == null) continue;
            if (ItemUtils.findMappedUnit(mappedRepo, iu) != null || ItemUtils.findMapRule(mappedRepo, iu) != null) {
                return false;
            }
            this.m_mapIUMappedRepo.put(iu, mappedRepo);
            boolean bl = someEnabled = someEnabled || mappedRepo.isBranchEnabled();
        }
        return this.m_mapIUMappedRepo.size() > 0 && someEnabled;
    }
}

