/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.buckminster.aggregator.Aggregator;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.Contribution;
import org.eclipse.buckminster.aggregator.MapRule;
import org.eclipse.buckminster.aggregator.MappedRepository;
import org.eclipse.buckminster.aggregator.MappedUnit;
import org.eclipse.buckminster.aggregator.p2.InstallableUnit;
import org.eclipse.buckminster.aggregator.p2.MetadataRepository;
import org.eclipse.buckminster.aggregator.p2view.IUPresentation;
import org.eclipse.buckminster.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemUtils {
    public static MappedUnit addIU(MappedRepository mappedRepo, InstallableUnit iu) {
        if (iu == null) {
            return null;
        }
        MappedUnit foundUnit = null;
        for (MappedUnit unit : mappedRepo.getUnits(false)) {
            if (unit.getInstallableUnit() == null || iu != unit.getInstallableUnit() && (iu.getId() == null || unit.getInstallableUnit().getId() == null || !iu.getId().equals(unit.getInstallableUnit().getId()))) continue;
            foundUnit = unit;
        }
        if (foundUnit != null) {
            return null;
        }
        MappedUnit newMU = AggregatorFactory.eINSTANCE.createMappedUnit(iu);
        mappedRepo.addUnit(newMU);
        return newMU;
    }

    public static MapRule addMapRule(MappedRepository mappedRepo, InstallableUnit iu, Class<? extends MapRule> ruleClass) {
        if (iu == null) {
            return null;
        }
        MapRule foundRule = null;
        for (MapRule rule : mappedRepo.getMapRules()) {
            if (rule.getInstallableUnit() == null || iu != rule.getInstallableUnit() && (iu.getId() == null || rule.getInstallableUnit().getId() == null || !iu.getId().equals(rule.getInstallableUnit().getId()))) continue;
            foundRule = rule;
        }
        if (foundRule != null) {
            return null;
        }
        MapRule newMR = AggregatorFactory.eINSTANCE.createMapRule(iu, ruleClass);
        mappedRepo.getMapRules().add((Object)newMR);
        return newMR;
    }

    public static MappedRepository addMDR(Contribution contribution, MetadataRepository mdr) {
        if (mdr == null) {
            return null;
        }
        if (ItemUtils.findMappedRepository(contribution, mdr) != null) {
            return null;
        }
        MappedRepository newMappedRepo = AggregatorFactory.eINSTANCE.createMappedRepository(mdr);
        contribution.getRepositories().add((Object)newMappedRepo);
        return newMappedRepo;
    }

    public static MappedRepository findMappedRepository(Aggregator aggregator, MetadataRepository mdr) {
        for (Contribution contribution : aggregator.getContributions()) {
            MappedRepository repo = ItemUtils.findMappedRepository(contribution, mdr);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    public static MappedRepository findMappedRepository(Contribution contribution, MetadataRepository mdr) {
        if (mdr == null) {
            return null;
        }
        for (MappedRepository repo : contribution.getRepositories()) {
            if (!mdr.equals(repo.getMetadataRepository()) || !repo.isBranchEnabled()) continue;
            return repo;
        }
        return null;
    }

    public static MappedUnit findMappedUnit(Aggregator aggregator, InstallableUnit iu) {
        MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
        for (Contribution contribution : aggregator.getContributions()) {
            for (MappedRepository repo : contribution.getRepositories()) {
                if (!mdr.equals(repo.getMetadataRepository())) continue;
                for (MappedUnit unit : repo.getUnits(false)) {
                    if (!iu.equals((Object)unit.getInstallableUnit())) continue;
                    return unit;
                }
            }
        }
        return null;
    }

    public static MappedUnit findMappedUnit(MappedRepository mappedRepo, InstallableUnit iu) {
        for (MappedUnit unit : mappedRepo.getUnits(false)) {
            if (!iu.equals((Object)unit.getInstallableUnit())) continue;
            return unit;
        }
        return null;
    }

    public static MapRule findMapRule(MappedRepository mappedRepo, InstallableUnit iu) {
        for (MapRule rule : mappedRepo.getMapRules()) {
            if (!iu.equals((Object)rule.getInstallableUnit())) continue;
            return rule;
        }
        return null;
    }

    public static Collection<? extends InstallableUnit> getIUs(Collection<? extends IUPresentation> iups) {
        ArrayList<InstallableUnit> set = new ArrayList<InstallableUnit>();
        for (IUPresentation iUPresentation : iups) {
            if (iUPresentation.getInstallableUnit() == null) continue;
            set.add(iUPresentation.getInstallableUnit());
        }
        return set;
    }

    public static Collection<MetadataRepository> getMDRs(Collection<? extends MetadataRepositoryStructuredView> mdrsvs) {
        HashSet<MetadataRepository> set = new HashSet<MetadataRepository>();
        for (MetadataRepositoryStructuredView metadataRepositoryStructuredView : mdrsvs) {
            if (metadataRepositoryStructuredView.getMetadataRepository() == null) continue;
            set.add(metadataRepositoryStructuredView.getMetadataRepository());
        }
        return set;
    }

    public static boolean haveSameLocation(MappedRepository mappedRepo, Collection<? extends InstallableUnit> selectedIUs) {
        String location = mappedRepo.getResolvedLocation();
        if (location == null) {
            return false;
        }
        for (InstallableUnit installableUnit : selectedIUs) {
            if (!(((EObject)installableUnit).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)installableUnit).eContainer();
            if (mdr.getLocation() == null) {
                return false;
            }
            if (location.equalsIgnoreCase(mdr.getLocation().toString())) continue;
            return false;
        }
        return true;
    }
}

