/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.presentation;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.aggregator.presentation.AggregatorEditor;
import org.eclipse.buckminster.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.buckminster.aggregator.presentation.UIUtils;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class FindIUDialog
extends TrayDialog {
    private static final int FIND_ID = 1025;
    private AggregatorEditor m_aggregatorEditor;
    private Text m_idPatternText;
    private Button m_regularExprButton;
    private ContentAssistCommandAdapter m_PatterFieldContentAssist;
    private Text m_versionFromText;
    private Text m_versionToText;
    private Button m_forwardButton;
    private Label m_statusLabel;
    private Button m_findButton;

    private static String getString(String key) {
        return AggregatorEditorPlugin.INSTANCE.getString(key);
    }

    protected FindIUDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.setShellStyle(1264);
        this.m_aggregatorEditor = (AggregatorEditor)window.getActivePage().getActivePart();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                this.close();
                break;
            }
            default: {
                if (!this.performAction(buttonId)) break;
                this.close();
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(FindIUDialog.getString("_UI_FindIUDialog_windowTitle"));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        this.m_findButton = this.createButton(composite, 1025, FindIUDialog.getString("_UI_FindIUDialog_findButton"), true);
        this.m_findButton.setEnabled(this.isFindEnabled());
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Control fContents = this.createPageArea(result);
        fContents.setLayoutData((Object)new GridData(1808));
        return result;
    }

    protected Control createPageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        new Label(composite, 0).setText(FindIUDialog.getString("_UI_FindIUDialog_installableUnitIDField"));
        this.m_idPatternText = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.m_idPatternText.setLayoutData((Object)layoutData);
        this.m_idPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindIUDialog.this.m_findButton.setEnabled(FindIUDialog.this.m_idPatternText.getCharCount() > 0);
            }
        });
        new Label(composite, 0);
        this.m_regularExprButton = new Button(composite, 32);
        this.m_regularExprButton.setText(FindIUDialog.getString("_UI_FindIUDialog_regularExpressionField"));
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.m_regularExprButton.setLayoutData((Object)layoutData);
        this.m_regularExprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindIUDialog.this.m_PatterFieldContentAssist.setEnabled(FindIUDialog.this.isFindEnabled());
            }
        });
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.m_PatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.m_idPatternText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'\\', '[', '('}, true);
        this.m_PatterFieldContentAssist.setEnabled(this.m_regularExprButton.getSelection());
        this.labelSeparator(composite);
        new Label(composite, 0).setText(FindIUDialog.getString("_UI_FindIUDialog_versionFromField"));
        this.m_versionFromText = new Text(composite, 2048);
        this.m_versionFromText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(FindIUDialog.getString("_UI_FindIUDialog_versionToField"));
        this.m_versionToText = new Text(composite, 2048);
        this.m_versionToText.setLayoutData((Object)new GridData(768));
        this.labelSeparator(composite);
        Group directionGroup = new Group(composite, 0);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        directionGroup.setLayoutData((Object)layoutData);
        directionGroup.setText(FindIUDialog.getString("_UI_FindIUDialog_directionGroupName"));
        directionGroup.setLayout((Layout)new GridLayout(2, true));
        this.m_forwardButton = new Button((Composite)directionGroup, 16);
        this.m_forwardButton.setText(FindIUDialog.getString("_UI_FindIUDialog_forwardButton"));
        Button backwardButton = new Button((Composite)directionGroup, 16);
        backwardButton.setText(FindIUDialog.getString("_UI_FindIUDialog_backwardButton"));
        this.m_forwardButton.setSelection(true);
        this.m_statusLabel = new Label(composite, 16384);
        layoutData = new GridData(4, 2, true, false);
        layoutData.horizontalSpan = 4;
        this.m_statusLabel.setLayoutData((Object)layoutData);
        return composite;
    }

    protected boolean performAction(int actionID) {
        switch (actionID) {
            case 1: {
                return true;
            }
            case 1025: {
                return this.performFind();
            }
        }
        return false;
    }

    private boolean isFindEnabled() {
        return this.m_regularExprButton.getSelection();
    }

    private void labelSeparator(Composite composite) {
        Label separatorLabel = new Label(composite, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 4;
        layoutData.heightHint = 8;
        separatorLabel.setLayoutData((Object)layoutData);
    }

    private boolean performFind() {
        Pattern idPattern = null;
        try {
            idPattern = this.m_regularExprButton.getSelection() ? Pattern.compile(UIUtils.trimmedValue(this.m_idPatternText)) : Pattern.compile(Pattern.quote(UIUtils.trimmedValue(this.m_idPatternText)));
        }
        catch (PatternSyntaxException e) {
            this.statusMessage(true, e.getLocalizedMessage());
            return false;
        }
        Version minVersion = null;
        String versionFromString = UIUtils.trimmedValue(this.m_versionFromText);
        minVersion = versionFromString != null ? Version.parseVersion((String)versionFromString) : Version.MIN_VERSION;
        Version maxVersion = null;
        String versionToString = UIUtils.trimmedValue(this.m_versionToText);
        maxVersion = versionToString != null ? Version.parseVersion((String)versionToString) : Version.MAX_VERSION;
        VersionRange versionRange = new VersionRange(minVersion, true, maxVersion, true);
        this.m_aggregatorEditor.registerFindIUArguments(idPattern, versionRange);
        if (this.m_aggregatorEditor.findNextIU(this.m_forwardButton.getSelection())) {
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, "String Not Found");
        }
        return false;
    }

    private void statusMessage(boolean error, String message) {
        this.m_statusLabel.setText(message);
        if (error) {
            this.m_statusLabel.setForeground(JFaceColors.getErrorText((Display)this.m_statusLabel.getDisplay()));
        } else {
            this.m_statusLabel.setForeground(null);
        }
        if (UIUtils.trimmedValue(message) != null) {
            this.getShell().getDisplay().beep();
        }
    }
}

