/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.aggregator.AggregatorFactory;
import org.eclipse.buckminster.aggregator.MavenItem;
import org.eclipse.buckminster.aggregator.MavenMapping;
import org.eclipse.buckminster.aggregator.StatusCode;
import org.eclipse.buckminster.aggregator.engine.maven.InstallableUnitOverrider;
import org.eclipse.buckminster.aggregator.engine.maven.MavenManager;
import org.eclipse.buckminster.aggregator.engine.maven.POM;
import org.eclipse.buckminster.aggregator.engine.maven.pom.DependenciesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Dependency;
import org.eclipse.buckminster.aggregator.engine.maven.pom.License;
import org.eclipse.buckminster.aggregator.engine.maven.pom.LicensesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Model;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Parent;
import org.eclipse.buckminster.aggregator.engine.maven.pom.PomFactory;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitMapping
implements IInstallableUnit {
    private static final Version DUMMY_VERSION = Version.parseVersion((String)"1");
    private Type m_type;
    private IInstallableUnit m_installableUnit;
    private List<MavenMapping> m_mappings;
    private MavenItem m_mapped;
    private InstallableUnitMapping m_parent;
    private List<InstallableUnitMapping> m_children = new ArrayList<InstallableUnitMapping>();
    private List<InstallableUnitMapping> m_siblings = new ArrayList<InstallableUnitMapping>();
    private boolean m_transient;
    private IArtifactKey m_mainArtifact;

    private static MavenItem map(String id, List<MavenMapping> mappings) throws CoreException {
        MavenItem item = null;
        for (MavenMapping mapping : mappings) {
            item = mapping.map(id);
            if (item == null) continue;
            return item;
        }
        StringBuilder mappingDescriptor = new StringBuilder();
        boolean first = true;
        for (MavenMapping mapping : mappings) {
            if (first) {
                first = false;
            } else {
                mappingDescriptor.append(',');
            }
            mappingDescriptor.append(mapping.toString());
        }
        throw BuckminsterException.fromMessage((String)"Unable to map IU to maven artifact: id=%s, mappings=%s", (Object[])new Object[]{id, mappingDescriptor.toString()});
    }

    public InstallableUnitMapping() {
        this((String)null);
    }

    public InstallableUnitMapping(IInstallableUnit iu) {
        this(iu, Collections.emptyList());
    }

    public InstallableUnitMapping(IInstallableUnit iu, List<MavenMapping> mappings) {
        this.m_mappings = new ArrayList<MavenMapping>(mappings.size() + 1);
        this.m_mappings.addAll(mappings);
        this.m_mappings.add(MavenMapping.DEFAULT_MAPPING);
        for (MavenMapping mapping : this.m_mappings) {
            if (mapping.getStatus().getCode() == StatusCode.OK) continue;
            throw new RuntimeException("Invalid maven mapping: " + mapping.toString());
        }
        switch (iu.getArtifacts().length) {
            case 1: {
                this.m_mainArtifact = iu.getArtifacts()[0];
            }
            case 0: {
                this.m_type = Type.IU;
                this.m_installableUnit = iu;
                break;
            }
            default: {
                InstallableUnitOverrider proxy = new InstallableUnitOverrider(iu);
                IRequiredCapability[] dependencies = new IRequiredCapability[iu.getArtifacts().length];
                int idx = 0;
                IArtifactKey[] iArtifactKeyArray = iu.getArtifacts();
                int n = iArtifactKeyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IArtifactKey artifact = iArtifactKeyArray[n2];
                    String genId = String.valueOf(artifact.getId()) + ".artifact-" + (idx + 1);
                    dependencies[idx++] = new RequiredCapability("org.eclipse.equinox.p2.iu", genId, new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, false, false);
                    InstallableUnitOverrider sibling = new InstallableUnitOverrider(iu);
                    sibling.overrideId(genId);
                    sibling.overrideArtifacts(new IArtifactKey[]{artifact});
                    this.m_siblings.add(new InstallableUnitMapping(sibling));
                    ++n2;
                }
                proxy.overrideRequiredCapabilities(dependencies);
                proxy.overrideArtifacts(new IArtifactKey[0]);
                this.m_installableUnit = proxy;
            }
        }
    }

    public InstallableUnitMapping(String name) {
        String groupId = name;
        if (groupId == null) {
            groupId = "_top";
        }
        String artifactId = name == null ? "_common" : "_group-common";
        this.m_type = name == null ? Type.TOP : Type.GROUP;
        InstallableUnit installableUnit = new InstallableUnit();
        installableUnit.setId(artifactId);
        installableUnit.setVersion(DUMMY_VERSION);
        this.m_installableUnit = installableUnit;
        this.m_mapped = AggregatorFactory.eINSTANCE.createMavenItem();
        this.m_mapped.setGroupId(groupId);
        this.m_mapped.setArtifactId(artifactId);
    }

    public POM asPOM() throws CoreException {
        ICopyright iuCopyright;
        IRequiredCapability[] requiredCapabilities;
        POM pom = new POM();
        Model model = pom.getProject();
        if (this.m_parent != null && !this.m_parent.isTransient()) {
            Parent parent = PomFactory.eINSTANCE.createParent();
            parent.setGroupId(this.m_parent.map().getGroupId());
            parent.setArtifactId(this.m_parent.map().getArtifactId());
            parent.setVersion(this.m_parent.getVersion().toString());
            model.setParent(parent);
        }
        model.setGroupId(this.map().getGroupId());
        model.setArtifactId(this.map().getArtifactId());
        if (this.getMainArtifact() == null) {
            model.setPackaging("pom");
        }
        if (this.getVersion() != null && !this.getVersion().equals((Object)Version.emptyVersion)) {
            model.setVersion(this.getVersionString());
        }
        if ((requiredCapabilities = this.getRequiredCapabilities()).length > 0) {
            DependenciesType dependencies = PomFactory.eINSTANCE.createDependenciesType();
            IRequiredCapability[] iRequiredCapabilityArray = requiredCapabilities;
            int n = requiredCapabilities.length;
            int n2 = 0;
            while (n2 < n) {
                IRequiredCapability requiredCapability = iRequiredCapabilityArray[n2];
                if ("org.eclipse.equinox.p2.iu".equals(requiredCapability.getNamespace()) || "osgi.bundle".equals(requiredCapability.getNamespace())) {
                    Dependency dependency = PomFactory.eINSTANCE.createDependency();
                    dependencies.getDependency().add((Object)dependency);
                    MavenItem dependencyMapping = InstallableUnitMapping.map(requiredCapability.getName(), this.m_mappings);
                    dependency.setGroupId(dependencyMapping.getGroupId());
                    dependency.setArtifactId(dependencyMapping.getArtifactId());
                    if (requiredCapability.getRange() != null && !requiredCapability.getRange().equals((Object)VersionRange.emptyRange)) {
                        StringBuilder versionRangeString = new StringBuilder();
                        Version low = requiredCapability.getRange().getMinimum();
                        Version high = requiredCapability.getRange().getMaximum();
                        if (requiredCapability.getRange().getIncludeMinimum() && Version.MAX_VERSION.equals((Object)high)) {
                            versionRangeString.append(MavenManager.getVersionString(low));
                        } else {
                            versionRangeString.append(requiredCapability.getRange().getIncludeMinimum() ? (char)'[' : '(');
                            versionRangeString.append(MavenManager.getVersionString(low));
                            versionRangeString.append(',');
                            versionRangeString.append(MavenManager.getVersionString(high));
                            versionRangeString.append(requiredCapability.getRange().getIncludeMaximum() ? (char)']' : ')');
                        }
                        dependency.setVersion(versionRangeString.toString());
                    }
                    if (requiredCapability.isOptional()) {
                        dependency.setOptional(true);
                    }
                }
                ++n2;
            }
            if (dependencies.getDependency().size() > 0) {
                model.setDependencies(dependencies);
            }
        }
        HashMap<String, String> iuProperties = new HashMap<String, String>(this.m_installableUnit.getProperties());
        String name = this.extractProperty(iuProperties, "org.eclipse.equinox.p2.name");
        String description = this.extractProperty(iuProperties, "org.eclipse.equinox.p2.description");
        if (name != null || description != null) {
            if (name != null) {
                if (description != null) {
                    name = String.valueOf(name) + "\n\n";
                }
            } else {
                name = "";
            }
            if (description == null) {
                description = "";
            }
            model.setDescription(String.valueOf(name) + description);
        }
        LicensesType licenses = PomFactory.eINSTANCE.createLicensesType();
        ILicense iuLicense = this.m_installableUnit.getLicense();
        if (iuLicense != null) {
            License license = PomFactory.eINSTANCE.createLicense();
            boolean licenseSet = false;
            if (iuLicense.getLocation() != null) {
                licenseSet = true;
                license.setUrl(iuLicense.getLocation().toString());
            }
            if (iuLicense.getBody() != null) {
                licenseSet = true;
                license.setComments(iuLicense.getBody());
            }
            if (licenseSet) {
                licenses.getLicense().add((Object)license);
            }
        }
        if ((iuCopyright = this.m_installableUnit.getCopyright()) != null) {
            License copyright = PomFactory.eINSTANCE.createLicense();
            boolean copyrightSet = false;
            if (iuCopyright.getLocation() != null) {
                copyrightSet = true;
                copyright.setUrl(iuCopyright.getLocation().toString());
            }
            if (iuCopyright.getBody() != null) {
                copyrightSet = true;
                copyright.setComments(iuCopyright.getBody());
            }
            if (copyrightSet) {
                licenses.getLicense().add((Object)copyright);
            }
        }
        if (licenses.getLicense().size() > 0) {
            model.setLicenses(licenses);
        }
        return pom;
    }

    public int compareTo(Object o) {
        return this.m_installableUnit.compareTo(o);
    }

    public IArtifactKey[] getArtifacts() {
        return this.m_installableUnit.getArtifacts();
    }

    public List<InstallableUnitMapping> getChildren() {
        return this.m_children;
    }

    public ICopyright getCopyright() {
        return this.m_installableUnit.getCopyright();
    }

    public String getFilter() {
        return this.m_installableUnit.getFilter();
    }

    public IInstallableUnitFragment[] getFragments() {
        return this.m_installableUnit.getFragments();
    }

    public String getId() {
        return this.m_installableUnit.getId();
    }

    public ILicense getLicense() {
        return this.m_installableUnit.getLicense();
    }

    public IArtifactKey getMainArtifact() {
        return this.m_mainArtifact;
    }

    public IRequiredCapability[] getMetaRequiredCapabilities() {
        return this.m_installableUnit.getMetaRequiredCapabilities();
    }

    public InstallableUnitMapping getParent() {
        return this.m_parent;
    }

    public String getPomName() throws CoreException {
        return this.getFileName("pom");
    }

    public Map getProperties() {
        return this.m_installableUnit.getProperties();
    }

    public String getProperty(String key) {
        return this.m_installableUnit.getProperty(key);
    }

    public IProvidedCapability[] getProvidedCapabilities() {
        return this.m_installableUnit.getProvidedCapabilities();
    }

    public String getRelativeFullPath() throws CoreException {
        return String.valueOf(this.getRelativePath()) + "/" + this.getArtifactFileName();
    }

    public String getRelativePath() throws CoreException {
        return String.valueOf(this.map().getGroupId().replace('.', '/')) + "/" + this.map().getArtifactId() + "/" + this.getVersionString();
    }

    public IRequiredCapability[] getRequiredCapabilities() {
        if (this.m_parent != null) {
            ArrayList<IRequiredCapability> myList = new ArrayList<IRequiredCapability>();
            List<IRequiredCapability> parentList = Arrays.asList(this.m_parent.m_installableUnit.getRequiredCapabilities());
            IRequiredCapability[] iRequiredCapabilityArray = this.m_installableUnit.getRequiredCapabilities();
            int n = iRequiredCapabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRequiredCapability my = iRequiredCapabilityArray[n2];
                if (!parentList.contains(my)) {
                    myList.add(my);
                }
                ++n2;
            }
            return myList.toArray(new IRequiredCapability[myList.size()]);
        }
        return this.m_installableUnit.getRequiredCapabilities();
    }

    public List<InstallableUnitMapping> getSiblings() {
        return this.m_siblings;
    }

    public ITouchpointData[] getTouchpointData() {
        return this.m_installableUnit.getTouchpointData();
    }

    public ITouchpointType getTouchpointType() {
        return this.m_installableUnit.getTouchpointType();
    }

    public Type getType() {
        return this.m_type;
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.m_installableUnit.getUpdateDescriptor();
    }

    public Version getVersion() {
        return this.m_installableUnit.getVersion();
    }

    public String getVersionString() {
        return MavenManager.getVersionString(this.getVersion());
    }

    public boolean isFragment() {
        return this.m_installableUnit.isFragment();
    }

    public boolean isResolved() {
        return this.m_installableUnit.isResolved();
    }

    public boolean isSingleton() {
        return this.m_installableUnit.isSingleton();
    }

    public boolean isTransient() {
        return this.m_transient;
    }

    public MavenItem map() throws CoreException {
        if (this.m_mapped != null) {
            return this.m_mapped;
        }
        this.m_mapped = InstallableUnitMapping.map(this.getId(), this.m_mappings);
        return this.m_mapped;
    }

    public boolean satisfies(IRequiredCapability candidate) {
        return this.m_installableUnit.satisfies(candidate);
    }

    public void setParent(InstallableUnitMapping parent) {
        if (this.m_parent != null) {
            this.m_parent.m_children.remove(this);
        }
        this.m_parent = parent;
        this.m_parent.m_children.add(this);
    }

    public void setTransient(boolean isTransient) {
        this.m_transient = isTransient;
    }

    public IInstallableUnit unresolved() {
        return this.m_installableUnit.unresolved();
    }

    private String extractProperty(Map<String, String> iuProperties, String key) {
        String localizedKey;
        String localizedValue;
        String value = iuProperties.remove(key);
        if (value != null && value.startsWith("%") && (localizedValue = iuProperties.remove(localizedKey = "df_LT." + value.substring(1))) != null) {
            value = localizedValue;
        }
        return this.trimOrNull(value);
    }

    private String getArtifactFileName() throws CoreException {
        return this.getFileName(null);
    }

    private String getFileName(String extension) throws CoreException {
        String fileId = this.getId();
        StringBuilder fileName = new StringBuilder(fileId);
        fileName.append('-');
        fileName.append(this.getVersionString());
        if (extension == null) {
            if (this.getMainArtifact() == null || !"binary".equals(this.getMainArtifact().getClassifier())) {
                fileName.append(".jar");
            }
        } else {
            fileName.append('.');
            fileName.append(extension);
        }
        return fileName.toString();
    }

    private String trimOrNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TOP,
        GROUP,
        IU,
        PROXY;

    }
}

