/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.aggregator.engine.maven;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.aggregator.engine.maven.POM;
import org.eclipse.buckminster.aggregator.engine.maven.ResolvedModelBase;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Build;
import org.eclipse.buckminster.aggregator.engine.maven.pom.CiManagement;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Contributor;
import org.eclipse.buckminster.aggregator.engine.maven.pom.ContributorsType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.DependenciesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Dependency;
import org.eclipse.buckminster.aggregator.engine.maven.pom.DependencyManagement;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Developer;
import org.eclipse.buckminster.aggregator.engine.maven.pom.DevelopersType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.DistributionManagement;
import org.eclipse.buckminster.aggregator.engine.maven.pom.IssueManagement;
import org.eclipse.buckminster.aggregator.engine.maven.pom.License;
import org.eclipse.buckminster.aggregator.engine.maven.pom.LicensesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.MailingList;
import org.eclipse.buckminster.aggregator.engine.maven.pom.MailingListsType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.ModulesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Organization;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Parent;
import org.eclipse.buckminster.aggregator.engine.maven.pom.PluginRepositoriesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Prerequisites;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Profile;
import org.eclipse.buckminster.aggregator.engine.maven.pom.ProfilesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.PropertiesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Reporting;
import org.eclipse.buckminster.aggregator.engine.maven.pom.ReportsType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.RepositoriesType;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Repository;
import org.eclipse.buckminster.aggregator.engine.maven.pom.Scm;
import org.eclipse.buckminster.aggregator.engine.maven.pom.impl.ModelImpl;
import org.eclipse.buckminster.aggregator.util.GeneralUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedModel
extends ResolvedModelBase {
    private String m_repoRoot;
    private ModelImpl m_original;
    private Map<String, String> m_propertyMap;
    private String m_artifactId;
    private boolean m_artifactIdResolved;
    private Build m_build;
    private boolean m_buildResolved;
    private CiManagement m_ciManagement;
    private boolean m_ciManagementResolved;
    private ContributorsType m_contributors;
    private boolean m_contributorsResolved;
    private DependenciesType m_dependencies;
    private boolean m_dependenciesResolved;
    private DependencyManagement m_dependencyManagement;
    private boolean m_dependencyManagementResolved;
    private String m_description;
    private boolean m_descriptionResolved;
    private DevelopersType m_developers;
    private boolean m_developersResolved;
    private DistributionManagement m_distributionManagement;
    private boolean m_distributionManagementResolved;
    private String m_groupId;
    private boolean m_groupIdResolved;
    private String m_inceptionYear;
    private boolean m_inceptionYearResolved;
    private IssueManagement m_issueManagement;
    private boolean m_issueManagementResolved;
    private LicensesType m_licenses;
    private boolean m_licensesResolved;
    private MailingListsType m_mailingLists;
    private boolean m_mailingListsResolved;
    private String m_modelVersion;
    private boolean m_modelVersionResolved;
    private ModulesType m_modules;
    private boolean m_modulesResolved;
    private String m_name;
    private boolean m_nameResolved;
    private Organization m_organization;
    private boolean m_organizationResolved;
    private String m_packaging;
    private boolean m_packagingResolved;
    private PluginRepositoriesType m_pluginRepositories;
    private boolean m_pluginRepositoriesResolved;
    private Prerequisites m_prerequisites;
    private boolean m_prerequisitesResolved;
    private ProfilesType m_profiles;
    private boolean m_profilesResolved;
    private Reporting m_reporting;
    private boolean m_reportingResolved;
    private RepositoriesType m_repositories;
    private boolean m_repositoriesResolved;
    private Scm m_scm;
    private boolean m_scmResolved;
    private String m_url;
    private boolean m_urlResolved;
    private String m_version;
    private boolean m_versionResolved;

    public ResolvedModel(String repoRoot, ModelImpl original) {
        this.m_repoRoot = repoRoot;
        this.m_original = original;
        this.m_propertyMap = null;
    }

    @Override
    public String getArtifactId() {
        if (!this.m_artifactIdResolved) {
            this.m_artifactIdResolved = true;
            this.m_artifactId = (String)this.resolveFeature(3);
        }
        return this.m_artifactId;
    }

    @Override
    public Build getBuild() {
        if (!this.m_buildResolved) {
            this.m_buildResolved = true;
            this.m_build = (Build)this.resolveFeature(19);
        }
        return this.m_build;
    }

    @Override
    public CiManagement getCiManagement() {
        if (!this.m_ciManagementResolved) {
            this.m_ciManagementResolved = true;
            this.m_ciManagement = (CiManagement)this.resolveFeature(11);
        }
        return this.m_ciManagement;
    }

    @Override
    public ContributorsType getContributors() {
        if (!this.m_contributorsResolved) {
            this.m_contributorsResolved = true;
            this.m_contributors = this.resolveWrappedListFeature(15, 0, ContributorsType.class, Contributor.class);
        }
        return this.m_contributors;
    }

    @Override
    public DependenciesType getDependencies() {
        if (!this.m_dependenciesResolved) {
            this.m_dependenciesResolved = true;
            this.m_dependencies = this.resolveWrappedListFeature(24, 0, DependenciesType.class, Dependency.class);
        }
        return this.m_dependencies;
    }

    @Override
    public DependencyManagement getDependencyManagement() {
        if (!this.m_dependencyManagementResolved) {
            this.m_dependencyManagementResolved = true;
            this.m_dependencyManagement = (DependencyManagement)this.resolveFeature(27);
        }
        return this.m_dependencyManagement;
    }

    @Override
    public String getDescription() {
        if (!this.m_descriptionResolved) {
            this.m_descriptionResolved = true;
            this.m_description = (String)this.resolveFeature(7);
        }
        return this.m_description;
    }

    @Override
    public DevelopersType getDevelopers() {
        if (!this.m_developersResolved) {
            this.m_developersResolved = true;
            this.m_developers = this.resolveWrappedListFeature(14, 0, DevelopersType.class, Developer.class);
        }
        return this.m_developers;
    }

    @Override
    public DistributionManagement getDistributionManagement() {
        if (!this.m_distributionManagementResolved) {
            this.m_distributionManagementResolved = true;
            this.m_distributionManagement = (DistributionManagement)this.resolveFeature(28);
        }
        return this.m_distributionManagement;
    }

    @Override
    public String getGroupId() {
        if (!this.m_groupIdResolved) {
            this.m_groupIdResolved = true;
            this.m_groupId = (String)this.resolveFeature(2);
        }
        return this.m_groupId;
    }

    @Override
    public String getInceptionYear() {
        if (!this.m_inceptionYearResolved) {
            this.m_inceptionYearResolved = true;
            this.m_inceptionYear = (String)this.resolveFeature(12);
        }
        return this.m_inceptionYear;
    }

    @Override
    public IssueManagement getIssueManagement() {
        if (!this.m_issueManagementResolved) {
            this.m_issueManagementResolved = true;
            this.m_issueManagement = (IssueManagement)this.resolveFeature(10);
        }
        return this.m_issueManagement;
    }

    @Override
    public LicensesType getLicenses() {
        if (!this.m_licensesResolved) {
            this.m_licensesResolved = true;
            this.m_licenses = this.resolveWrappedListFeature(16, 0, LicensesType.class, License.class);
        }
        return this.m_licenses;
    }

    @Override
    public MailingListsType getMailingLists() {
        if (!this.m_mailingListsResolved) {
            this.m_mailingListsResolved = true;
            this.m_mailingLists = this.resolveWrappedListFeature(13, 0, MailingListsType.class, MailingList.class);
        }
        return this.m_mailingLists;
    }

    @Override
    public String getModelVersion() {
        if (!this.m_modelVersionResolved) {
            this.m_modelVersionResolved = true;
            this.m_modelVersion = (String)this.resolveFeature(1);
        }
        return this.m_modelVersion;
    }

    @Override
    public ModulesType getModules() {
        if (!this.m_modulesResolved) {
            this.m_modulesResolved = true;
            this.m_modules = this.resolveWrappedListFeature(21, 0, ModulesType.class, String.class);
        }
        return this.m_modules;
    }

    @Override
    public String getName() {
        if (!this.m_nameResolved) {
            this.m_nameResolved = true;
            this.m_name = (String)this.resolveFeature(5);
        }
        return this.m_name;
    }

    @Override
    public Organization getOrganization() {
        if (!this.m_organizationResolved) {
            this.m_organizationResolved = true;
            this.m_organization = (Organization)this.resolveFeature(18);
        }
        return this.m_organization;
    }

    @Override
    public String getPackaging() {
        if (!this.m_packagingResolved) {
            this.m_packagingResolved = true;
            this.m_packaging = (String)this.resolveFeature(4);
        }
        return this.m_packaging;
    }

    @Override
    public Parent getParent() {
        return this.m_original.getParent();
    }

    @Override
    public PluginRepositoriesType getPluginRepositories() {
        if (!this.m_pluginRepositoriesResolved) {
            this.m_pluginRepositoriesResolved = true;
            this.m_pluginRepositories = this.resolveWrappedListFeature(23, 0, PluginRepositoriesType.class, Repository.class);
        }
        return this.m_pluginRepositories;
    }

    @Override
    public Prerequisites getPrerequisites() {
        if (!this.m_prerequisitesResolved) {
            this.m_prerequisitesResolved = true;
            this.m_prerequisites = (Prerequisites)this.resolveFeature(9);
        }
        return this.m_prerequisites;
    }

    @Override
    public ProfilesType getProfiles() {
        if (!this.m_profilesResolved) {
            this.m_profilesResolved = true;
            this.m_profiles = this.resolveWrappedListFeature(20, 0, ProfilesType.class, Profile.class);
        }
        return this.m_profiles;
    }

    @Override
    public PropertiesType getProperties() {
        throw new UnsupportedOperationException("Use POM.getFullPropertyMap() instead");
    }

    public Map<String, String> getPropertyMap() throws CoreException {
        if (this.m_propertyMap == null) {
            this.m_propertyMap = new HashMap<String, String>();
            String version = this.getVersion();
            this.m_propertyMap.put("version", version);
            this.m_propertyMap.put("pom.version", version);
            this.m_propertyMap.put("project.version", version);
            String name = this.getName();
            this.m_propertyMap.put("pom.name", name);
            this.m_propertyMap.put("project.name", name);
            this.m_propertyMap.putAll(this.getPropertiesAsMap());
            Parent parent = this.getParent();
            if (parent != null) {
                this.m_propertyMap.put("parent.version", parent.getVersion());
                ResolvedModel parentModel = POM.getPOM(this.m_repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getResolvedProject();
                for (Map.Entry<String, String> entry : parentModel.getPropertyMap().entrySet()) {
                    if (this.m_propertyMap.containsKey(entry.getKey())) continue;
                    this.m_propertyMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.m_propertyMap;
    }

    @Override
    public Reporting getReporting() {
        if (!this.m_reportingResolved) {
            this.m_reportingResolved = true;
            this.m_reporting = (Reporting)this.resolveFeature(26);
        }
        return this.m_reporting;
    }

    @Override
    public ReportsType getReports() {
        throw new UnsupportedOperationException("reports resolution is not supported in this version");
    }

    @Override
    public RepositoriesType getRepositories() {
        if (!this.m_repositoriesResolved) {
            this.m_repositoriesResolved = true;
            this.m_repositories = this.resolveWrappedListFeature(22, 0, RepositoriesType.class, Repository.class);
        }
        return this.m_repositories;
    }

    @Override
    public Scm getScm() {
        if (!this.m_scmResolved) {
            this.m_scmResolved = true;
            this.m_scm = (Scm)this.resolveFeature(17);
        }
        return this.m_scm;
    }

    @Override
    public String getUrl() {
        if (!this.m_urlResolved) {
            this.m_urlResolved = true;
            this.m_url = (String)this.resolveFeature(8);
        }
        return this.m_url;
    }

    @Override
    public String getVersion() {
        if (!this.m_versionResolved) {
            this.m_versionResolved = true;
            this.m_version = (String)this.resolveFeature(6);
        }
        return this.m_version;
    }

    @Override
    public boolean isSetPackaging() {
        return this.getPackaging() != null;
    }

    private Map<String, String> getPropertiesAsMap() throws CoreException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        PropertiesType propertiesType = this.m_original.getProperties();
        if (propertiesType != null) {
            FeatureMap properties = this.m_original.getProperties().getAny();
            int i = properties.size() - 1;
            while (i >= 0) {
                String value;
                FeatureMap.Entry entry = (FeatureMap.Entry)properties.get(i);
                FeatureMap valueMap = ((AnyTypeImpl)entry.getValue()).getMixed();
                switch (valueMap.size()) {
                    case 0: {
                        value = null;
                        break;
                    }
                    case 1: {
                        value = (String)((AnyTypeImpl)entry.getValue()).getMixed().getValue(0);
                        break;
                    }
                    default: {
                        throw BuckminsterException.fromMessage((String)"Unexpected property map size: %d", (Object[])new Object[]{valueMap.size()});
                    }
                }
                propertyMap.put(entry.getEStructuralFeature().getName(), value);
                --i;
            }
        }
        return propertyMap;
    }

    private <T> T resolveFeature(int featureID) {
        try {
            Parent parent;
            Object result = this.m_original.eGet(featureID, false, false);
            if (result instanceof String) {
                result = GeneralUtils.trimmedOrNull((String)((String)result));
            }
            if (result == null && (parent = this.getParent()) != null) {
                result = POM.getPOM(this.m_repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getResolvedProject().resolveFeature(featureID);
            }
            if (result instanceof String) {
                result = POM.expandProperties((String)result, this.getPropertyMap());
            }
            return (T)result;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private <T, L> T resolveWrappedListFeature(int wrapperID, int featureID, Class<T> wrapperClass, Class<L> featureClass) {
        try {
            ModelImpl model = this.m_original;
            T result = wrapperClass.newInstance();
            EObjectContainmentEList list = new EObjectContainmentEList(featureClass, (InternalEObject)result, featureID);
            ((EObjectImpl)result).eSet(wrapperID, (Object)list);
            while (model != null) {
                Parent parent;
                List semiList;
                Object semiResult = model.eGet(featureID, false, false);
                if (semiResult != null && (semiList = (List)((EObjectImpl)semiResult).eGet(wrapperID, false, false)) != null) {
                    list.addAll(semiList);
                }
                model = (parent = model.getParent()) != null ? (ModelImpl)POM.getPOM(this.m_repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()).getProject() : null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

