/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversive.internal;

import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.utility.SubProgressMonitorWithInfo;

public class SimpleMonitorWrapper
implements ISVNProgressMonitor {
    private final SubProgressMonitorWithInfo m_monitor;

    public static ISVNProgressMonitor beginTask(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new SVNNullProgressMonitor();
        }
        monitor.beginTask(null, ticks);
        return new SimpleMonitorWrapper(monitor, ticks);
    }

    private SimpleMonitorWrapper(IProgressMonitor monitor, int ticks) {
        this.m_monitor = new SubProgressMonitorWithInfo(monitor, (double)ticks);
    }

    public boolean isActivityCancelled() {
        return this.m_monitor.isCanceled();
    }

    public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
        if (total != -1) {
            int real = 100 * current / total;
            this.m_monitor.worked(real -= this.m_monitor.getCurrentProgress());
        } else {
            this.m_monitor.unknownProgress(current);
        }
    }

    public void reportError(String msg) {
        Buckminster.getLogger().info("SVN error: " + msg, new Object[0]);
    }
}

