/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversive.internal;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.subversion.GenericSession;
import org.eclipse.buckminster.subversion.ISubversionCache;
import org.eclipse.buckminster.subversion.ISvnEntryHelper;
import org.eclipse.buckminster.subversion.Messages;
import org.eclipse.buckminster.subversion.RepositoryAccess;
import org.eclipse.buckminster.subversive.internal.SimpleMonitorWrapper;
import org.eclipse.buckminster.subversive.internal.SubversiveCache;
import org.eclipse.buckminster.subversive.internal.SubversiveEntryHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversiveSession
extends GenericSession<IRepositoryLocation, SVNEntry, SVNRevision> {
    private static final SubversiveEntryHelper HELPER = new SubversiveEntryHelper();
    private static final SVNEntry[] s_emptyFolder = new SVNEntry[0];
    private static final String UNKNOWN_ROOT_PREFIX = String.valueOf(SubversiveSession.class.getPackage().getName()) + ".root.";
    private ISVNConnector m_proxy;

    public static URI getURIParent(URI uri) {
        if (uri == null) {
            return null;
        }
        String path = uri.toString();
        if (path == null) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == path.length() - 1 && lastSlash > 0) {
            path = path.substring(0, path.length() - 1);
            lastSlash = path.lastIndexOf(47);
        }
        if (lastSlash < 0) {
            return null;
        }
        String parentPath = path.substring(0, lastSlash);
        try {
            return new URI(parentPath);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public SubversiveSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        super(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    public void close() {
        this.m_proxy.dispose();
    }

    protected void createRoots(Collection<RepositoryAccess> sourceRoots) throws CoreException {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        for (RepositoryAccess root : sourceRoots) {
            IRepositoryLocation location = storage.newRepositoryLocation();
            location.setUrl(root.getSvnURL().toString());
            location.setPassword(root.getPassword());
            location.setUsername(root.getUser());
            storage.addRepositoryLocation(location);
        }
        try {
            storage.saveConfiguration();
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected ISubversionCache<SVNEntry> getCache(Map<UUID, Object> userCache) {
        assert (this.m_cache == null);
        SubversiveCache cache = new SubversiveCache();
        cache.initialize(userCache);
        return cache;
    }

    public SVNEntry getDirEntry(URI uri, SVNRevision revision, IProgressMonitor monitor) throws CoreException {
        SVNEntry[] entries;
        URI parent = SubversiveSession.getURIParent(uri);
        if (parent == null) {
            return null;
        }
        String path = uri.getPath();
        String entryPath = path.substring(path.lastIndexOf(47) + 1);
        SVNEntry[] sVNEntryArray = entries = (SVNEntry[])this.listFolder(parent, monitor);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SVNEntry entry = sVNEntryArray[n2];
            if (entryPath.equals(entry.path)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    protected SVNEntry[] getEmptyEntryList() {
        return s_emptyFolder;
    }

    protected IRepositoryLocation[] getKnownRepositories() {
        return SVNRemoteStorage.instance().getRepositoryLocations();
    }

    public long getLastChangeNumber() throws CoreException {
        try {
            URI svnURL = this.getSVNUrl(null);
            SVNEntry root = this.getDirEntry(svnURL, (SVNRevision)this.getRevision(), null);
            if (root == null) {
                throw new FileNotFoundException(svnURL.toString());
            }
            return root.revision;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public Date getLastTimestamp() throws CoreException {
        try {
            URI svnURL = this.getSVNUrl(null);
            SVNEntry root = this.getDirEntry(svnURL, (SVNRevision)this.getRevision(), null);
            if (root == null) {
                throw new FileNotFoundException(svnURL.toString());
            }
            return new Date(root.date);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public SVNEntry getRootEntry(IProgressMonitor monitor) throws CoreException {
        return this.getDirEntry(this.getSVNUrl(null), (SVNRevision)this.getRevision(), monitor);
    }

    protected String getRootUrl(IRepositoryLocation location) {
        return location.getRoot().getUrl();
    }

    public ISvnEntryHelper<SVNEntry> getSvnEntryHelper() {
        return HELPER;
    }

    ISVNConnector getSVNProxy() {
        if (this.m_proxy == null) {
            this.m_proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().newInstance();
        }
        return this.m_proxy;
    }

    public SVNRevision getSVNRevision(long revision, Date timestamp) {
        if (revision == -1L) {
            if (timestamp == null) {
                return SVNRevision.HEAD;
            }
            return SVNRevision.fromDate((long)timestamp.getTime());
        }
        if (timestamp != null) {
            throw new IllegalArgumentException(Messages.svn_session_cannot_use_both_timestamp_and_revision_number);
        }
        return SVNRevision.fromNumber((long)revision);
    }

    protected String getUnknownRootPrefix() {
        return UNKNOWN_ROOT_PREFIX;
    }

    protected void initializeSvn(RMContext context, URI ourRoot, IRepositoryLocation bestMatch) {
        ISVNConnector proxy = this.getSVNProxy();
        proxy.setTouchUnresolved(false);
        proxy.setCommitMissingFiles(false);
        proxy.setSSLCertificateCacheEnabled(true);
        proxy.setUsername(this.m_username);
        proxy.setPassword(this.m_password);
        proxy.setCredentialsCacheEnabled(true);
        if (bestMatch == null) {
            this.addUnknownRoot(context.getBindingProperties(), new RepositoryAccess(ourRoot, this.m_username, this.m_password));
        } else {
            SVNUtility.configureProxy((ISVNConnector)proxy, (IRepositoryLocation)((IRepositoryLocation)this.m_repositoryLocation));
            IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
            ISVNCredentialsPrompt externalPrompt = optionProvider.getCredentialsPrompt();
            if (externalPrompt != null) {
                proxy.setPrompt((ISVNCredentialsPrompt)new SVNRepositoryLocation.BaseCredentialsPromptWrapper(externalPrompt, (IRepositoryLocation)this.m_repositoryLocation));
            }
        }
        if (this.m_username != null) {
            proxy.setPrompt((ISVNCredentialsPrompt)new UnattendedPromptUserPassword());
        }
    }

    protected SVNEntry[] innerListFolder(URI url, IProgressMonitor monitor) throws Exception {
        ISVNProgressMonitor svnMon = SimpleMonitorWrapper.beginTask(monitor, 100);
        return SVNUtility.list((ISVNConnector)this.m_proxy, (SVNEntryRevisionReference)new SVNEntryRevisionReference(url.toString(), null, (SVNRevision)this.getRevision()), (int)2, (int)-1, (long)0L, (ISVNProgressMonitor)svnMon);
    }

    public String toString() {
        try {
            return this.getSVNUrl(null).toString();
        }
        catch (CoreException e) {
            return super.toString();
        }
    }

    private class UnattendedPromptUserPassword
    implements ISVNCredentialsPrompt {
        private int m_promptLimit = 3;

        private UnattendedPromptUserPassword() {
        }

        public int askTrustSSLServer(Object location, String info, boolean allowPermanently) {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.askTrustSSLServer(location, info, allowPermanently);
        }

        public String getPassword() {
            return SubversiveSession.this.m_password;
        }

        public String getProxyHost() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getProxyHost();
        }

        public String getProxyPassword() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getProxyPassword();
        }

        public int getProxyPort() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getProxyPort();
        }

        public String getProxyUserName() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getProxyUserName();
        }

        public String getRealmToSave() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getRealmToSave();
        }

        public int getSSHPort() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getSSHPort();
        }

        public String getSSHPrivateKeyPassphrase() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getSSHPrivateKeyPassphrase();
        }

        public String getSSHPrivateKeyPath() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getSSHPrivateKeyPath();
        }

        public String getSSLClientCertPassword() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getSSLClientCertPassword();
        }

        public String getSSLClientCertPath() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.getSSLClientCertPath();
        }

        public String getUsername() {
            return SubversiveSession.this.m_username;
        }

        public boolean isProxyAuthenticationEnabled() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isProxyAuthenticationEnabled();
        }

        public boolean isProxyEnabled() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isProxyEnabled();
        }

        public boolean isSaveCredentialsEnabled() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSaveCredentialsEnabled();
        }

        public boolean isSaveProxyPassword() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSaveProxyPassword();
        }

        public boolean isSSHPrivateKeyPassphraseSaved() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSSHPrivateKeyPassphraseSaved();
        }

        public boolean isSSHPublicKeySelected() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSSHPublicKeySelected();
        }

        public boolean isSSLAuthenticationEnabled() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSSLAuthenticationEnabled();
        }

        public boolean isSSLSavePassphrase() {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.isSSLSavePassphrase();
        }

        public boolean prompt(Object arg0, String arg1) {
            return SubversiveSession.this.m_password != null && --this.m_promptLimit >= 0;
        }

        public boolean promptProxy(Object location) {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.promptProxy(location);
        }

        public boolean promptSSH(Object location, String realm) {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.promptSSH(location, realm);
        }

        public boolean promptSSL(Object location, String realm) {
            return ISVNCredentialsPrompt.DEFAULT_PROMPT.promptSSL(location, realm);
        }
    }
}

