/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttachableProgressMonitor {
    private ProgressMonitor m_monitor;
    private List<IProgressMonitor> m_attachedMonitors = new ArrayList<IProgressMonitor>();

    public void attachProgressMonitor(IProgressMonitor toAttach) {
        if (toAttach == null) {
            throw new IllegalArgumentException("The given IProgressMonitor must not be null");
        }
        if (this.m_monitor != null) {
            this.m_monitor.attachProgressMonitor(this.m_monitor);
        }
        this.m_attachedMonitors.add(toAttach);
    }

    public IProgressMonitor wrap(IProgressMonitor mainProgressMonitor) {
        if (mainProgressMonitor == null) {
            throw new IllegalArgumentException("The given IProgressMonitor must not be null");
        }
        if (this.m_monitor != null) {
            throw new RuntimeException("Only one ProgressMonitor can be wrapped at a time");
        }
        this.m_monitor = new ProgressMonitor(mainProgressMonitor);
        for (IProgressMonitor monitor : this.m_attachedMonitors) {
            this.m_monitor.attachProgressMonitor(monitor);
        }
        return this.m_monitor;
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private int m_totalWork;
        private int m_ticks;
        private String m_task;
        private String m_subTask;
        private IProgressMonitor m_mainProgressMonitor;

        public ProgressMonitor(IProgressMonitor mainprogressMonitor) {
            this.m_mainProgressMonitor = mainprogressMonitor;
        }

        public void beginTask(String name, int totalWork) {
            this.m_totalWork = totalWork;
            this.m_task = name;
            this.m_mainProgressMonitor.beginTask(name, totalWork);
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.beginTask(name, totalWork);
            }
        }

        public void done() {
            this.m_mainProgressMonitor.done();
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.done();
            }
        }

        public void internalWorked(double work) {
            this.m_mainProgressMonitor.internalWorked(work);
            for (IProgressMonitor subMonitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                subMonitor.internalWorked(work);
            }
        }

        public boolean isCanceled() {
            return this.m_mainProgressMonitor.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.m_mainProgressMonitor.setCanceled(value);
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.setCanceled(value);
            }
        }

        public void setTaskName(String name) {
            this.m_mainProgressMonitor.setTaskName(name);
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.setTaskName(name);
            }
        }

        public void subTask(String name) {
            this.m_subTask = name;
            this.m_mainProgressMonitor.subTask(name);
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.subTask(name);
            }
        }

        public void worked(int work) {
            this.m_ticks += work;
            this.m_mainProgressMonitor.worked(work);
            for (IProgressMonitor monitor : AttachableProgressMonitor.this.m_attachedMonitors) {
                monitor.worked(work);
            }
        }

        void attachProgressMonitor(IProgressMonitor toAttach) {
            if (this.m_task != null) {
                toAttach.beginTask(this.m_task, this.m_totalWork);
                toAttach.worked(this.m_ticks);
            }
            if (this.m_subTask != null) {
                toAttach.subTask(this.m_subTask);
            }
        }
    }
}

