/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.subversion.GenericCache;
import org.eclipse.buckminster.subversion.ISubversionCache;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversion.Messages;
import org.eclipse.buckminster.subversion.RepositoryAccess;
import org.eclipse.buckminster.subversion.SvnExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSession<REPO_LOCATION_TYPE, SVN_ENTRY_TYPE, SVN_REVISION_TYPE>
implements ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> {
    protected final VersionSelector m_branchOrTag;
    protected REPO_LOCATION_TYPE m_repositoryLocation;
    protected final IPath m_module;
    protected final boolean m_moduleAfterBranch;
    protected final boolean m_moduleAfterTag;
    protected final boolean m_moduleBeforeBranch;
    protected final boolean m_moduleBeforeTag;
    protected final boolean m_trunkStructure;
    protected final String m_password;
    private final SVN_REVISION_TYPE m_revision;
    protected final IPath m_subModule;
    protected final String m_urlLeadIn;
    protected final String m_username;
    protected final ISubversionCache<SVN_ENTRY_TYPE> m_cache;

    private static Collection<RepositoryAccess> getCommonRootsStep(Collection<RepositoryAccess> source) throws CoreException {
        HashSet<RepositoryAccess> commonRoots = null;
        for (RepositoryAccess repoAccess : source) {
            URI url = repoAccess.getSvnURL();
            String[] urlSegs = Path.fromPortableString((String)url.getPath()).segments();
            for (RepositoryAccess repoAccessCmp : source) {
                if (repoAccess == repoAccessCmp) continue;
                URI cmp = repoAccessCmp.getSvnURL();
                if (!Trivial.equalsAllowNull((Object)url.getHost(), (Object)cmp.getHost()) || !Trivial.equalsAllowNull((Object)url.getScheme(), (Object)cmp.getScheme()) || url.getPort() != cmp.getPort()) continue;
                int maxSegs = urlSegs.length;
                String[] cmpSegs = Path.fromPortableString((String)cmp.getPath()).segments();
                if (maxSegs > cmpSegs.length) {
                    maxSegs = cmpSegs.length;
                }
                int idx = 0;
                while (idx < maxSegs) {
                    if (!urlSegs[idx].equals(cmpSegs[idx])) break;
                    ++idx;
                }
                if (idx < 1) continue;
                String user = repoAccess.getUser();
                String cmpUser = repoAccessCmp.getUser();
                if (user == null) {
                    user = cmpUser;
                } else if (cmpUser != null && !user.equals(cmpUser)) continue;
                String password = repoAccess.getPassword();
                String cmpPassword = repoAccessCmp.getPassword();
                if (password == null) {
                    password = cmpPassword;
                } else if (cmpPassword != null && !password.equals(cmpPassword)) continue;
                StringBuilder bld = new StringBuilder();
                bld.append(url.getScheme());
                bld.append("://");
                if (url.getHost() != null) {
                    bld.append(url.getHost());
                    if (url.getPort() != -1) {
                        bld.append(":");
                        bld.append(url.getPort());
                    }
                }
                int pdx = 0;
                while (pdx < idx) {
                    String seg = urlSegs[pdx];
                    bld.append('/');
                    if (idx > 0 && seg.equals("trunk") || seg.equals("tags") || seg.equals("branches")) break;
                    bld.append(seg);
                    ++pdx;
                }
                try {
                    if (commonRoots == null) {
                        commonRoots = new HashSet<RepositoryAccess>();
                    }
                    commonRoots.add(new RepositoryAccess(new URI(bld.toString()), user, password));
                }
                catch (URISyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }
        if (commonRoots == null) {
            return source;
        }
        HashSet<RepositoryAccess> rogueRoots = null;
        for (RepositoryAccess repoAccess : source) {
            boolean found = false;
            URI url = repoAccess.getSvnURL();
            String[] urlSegs = Path.fromPortableString((String)url.getPath()).segments();
            for (RepositoryAccess repoAccessCmp : commonRoots) {
                String[] cmpSegs;
                int maxSegs;
                URI cmp = repoAccessCmp.getSvnURL();
                if (!Trivial.equalsAllowNull((Object)url.getHost(), (Object)cmp.getHost()) || !Trivial.equalsAllowNull((Object)url.getScheme(), (Object)cmp.getScheme()) || url.getPort() != cmp.getPort() || (maxSegs = (cmpSegs = Path.fromPortableString((String)cmp.getPath()).segments()).length) > urlSegs.length) continue;
                int idx = 0;
                while (idx < maxSegs) {
                    if (!urlSegs[idx].equals(cmpSegs[idx])) break;
                    ++idx;
                }
                if (idx < maxSegs) continue;
                String user = repoAccess.getUser();
                String cmpUser = repoAccessCmp.getUser();
                if (user != null && cmpUser != null && !user.equals(cmpUser)) continue;
                String password = repoAccess.getPassword();
                String cmpPassword = repoAccessCmp.getPassword();
                if (password != null && cmpPassword != null && !password.equals(cmpPassword)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (rogueRoots == null) {
                rogueRoots = new HashSet<RepositoryAccess>();
            }
            rogueRoots.add(repoAccess);
        }
        if (rogueRoots != null) {
            commonRoots.addAll(rogueRoots);
        }
        return commonRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public GenericSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        super();
        this.m_revision = this.getSVNRevision(revision, timestamp);
        this.m_branchOrTag = branchOrTag;
        userCache = context.getUserCache();
        this.m_cache = this.getCache(userCache);
        try {
            uri = new URI(repositoryURI);
            fullPath = new Path(uri.getPath());
            pathSegments = fullPath.segments();
            idx = pathSegments.length;
            while (--idx >= 0) {
                if (pathSegments[idx].equals("trunk")) break;
            }
            if (idx >= 0) {
                this.m_trunkStructure = true;
            } else {
                this.m_trunkStructure = false;
                idx = pathSegments.length - 1;
            }
            if (this.m_branchOrTag != null && !this.m_trunkStructure) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.branch_or_tag_0_not_found, (Object)this.m_branchOrTag), (Object[])new Object[0]);
            }
            relPathLen = pathSegments.length - idx;
            bld = new StringBuilder();
            scheme = uri.getScheme();
            if (scheme != null) {
                bld.append(scheme);
                bld.append("://");
            }
            username = null;
            password = null;
            authority = uri.getAuthority();
            if (authority != null) {
                atIdx = authority.indexOf(64);
                if (atIdx > 0) {
                    authentication = authority.substring(0, atIdx);
                    authority = authority.substring(atIdx + 1);
                    upSplit = authentication.indexOf(58);
                    if (upSplit > 0) {
                        username = authentication.substring(0, upSplit);
                        if ("null".equals(username)) {
                            username = null;
                        }
                        if ("null".equals(password = authentication.substring(upSplit + 1))) {
                            password = null;
                        }
                    }
                }
                bld.append(authority);
            }
            this.m_username = username;
            this.m_password = password;
            if (fullPath.getDevice() != null) {
                bld.append('/');
            }
            bld.append(fullPath.removeLastSegments(relPathLen));
            urlLeadIn = bld.toString();
            modulePath = null;
            if (this.m_trunkStructure) {
                if (relPathLen > 1) {
                    modulePath = fullPath.removeFirstSegments(idx + 1);
                    modulePath = modulePath.setDevice(null);
                }
            } else {
                modulePath = Path.fromPortableString((String)fullPath.lastSegment());
            }
            this.m_module = modulePath;
            tmp = uri.getFragment();
            subModule = null;
            if (tmp != null) {
                subModule = new Path(tmp).makeRelative();
            }
            this.m_subModule = subModule;
            moduleBeforeTag = false;
            moduleAfterTag = false;
            moduleBeforeBranch = false;
            moduleAfterBranch = false;
            if (this.m_trunkStructure) {
                var29_28 /* !! */  = URLUtils.decodeToQueryPairs((String)uri.getQuery());
                var28_29 = var29_28 /* !! */ .length;
                var27_31 = 0;
                while (var27_31 < var28_29) {
                    entry = var29_28 /* !! */ [var27_31];
                    if (entry.equalsIgnoreCase("moduleBeforeTag")) {
                        moduleBeforeTag = true;
                    } else if (entry.equalsIgnoreCase("moduleAfterTag")) {
                        moduleAfterTag = true;
                    } else if (entry.equalsIgnoreCase("moduleBeforeBranch")) {
                        moduleBeforeBranch = true;
                    } else if (entry.equalsIgnoreCase("moduleAfterBranch")) {
                        moduleAfterBranch = true;
                    }
                    ++var27_31;
                }
            }
            this.m_moduleBeforeTag = moduleBeforeTag;
            this.m_moduleAfterTag = moduleAfterTag;
            this.m_moduleBeforeBranch = moduleBeforeBranch;
            this.m_moduleAfterBranch = moduleAfterBranch;
            rank = 0;
            ourRoot = new URI(urlLeadIn);
            bestMatch = null;
            var32_35 = this.getKnownRepositories();
            var31_36 = var32_35.length;
            var30_37 = 0;
            while (var30_37 < var31_36) {
                block37: {
                    block38: {
                        location = var32_35[var30_37];
                        repoRoot = new URI(this.getRootUrl(location));
                        if (!Trivial.equalsAllowNull((Object)repoRoot.getHost(), (Object)ourRoot.getHost())) break block37;
                        repoProto = repoRoot.getScheme().toLowerCase();
                        ourProto = ourRoot.getScheme().toLowerCase();
                        v0 = repoIsSSH = repoProto.equals("svn+ssh") != false || repoProto.equals("https") != false;
                        if (rank > 200 && !repoIsSSH || !repoProto.equals(ourProto) && (!repoProto.equals("svn") || !ourProto.equals("http")) && (!repoProto.equals("http") || !ourProto.equals("svn")) && (!ourProto.equals("svn") && !ourProto.equals("http") || !repoIsSSH)) break block37;
                        ourPath = Path.fromPortableString((String)ourRoot.getPath()).segments();
                        repoPath = Path.fromPortableString((String)repoRoot.getPath()).segments();
                        idx = repoPath.length;
                        if (idx <= (top = ourPath.length)) ** GOTO lbl-1000
                        break block37;
                        while (ourPath[idx].equals(repoPath[idx])) lbl-1000:
                        // 2 sources

                        {
                            if (--idx >= 0) continue;
                        }
                        if (idx >= 0) break block37;
                        urlLeadIn = repoRoot.toString();
                        diff = top - repoPath.length;
                        if (diff <= 0) break block38;
                        myRank = (repoIsSSH != false ? 400 : 200) - diff;
                        if (rank > myRank) break block37;
                        bld.setLength(0);
                        bld.append(urlLeadIn);
                        idx = repoPath.length;
                        while (idx < top) {
                            bld.append('/');
                            bld.append(ourPath[idx]);
                            ++idx;
                        }
                        urlLeadIn = bld.toString();
                    }
                    rank = (repoIsSSH != false ? 400 : 200) - diff;
                    bestMatch = location;
                    if (rank == 400) break;
                }
                ++var30_37;
            }
            this.m_urlLeadIn = urlLeadIn;
            this.m_repositoryLocation = bestMatch;
            var29_28 /* !! */  = userCache;
            synchronized (var29_28 /* !! */ ) {
                this.initializeSvn(context, ourRoot, bestMatch);
            }
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final void createCommonRoots(RMContext context) throws CoreException {
        List<RepositoryAccess> unknownRoots = this.getUnknownRoots(context.getBindingProperties());
        if (unknownRoots.size() == 0) {
            return;
        }
        Collection<RepositoryAccess> sourceRoots = unknownRoots;
        if (unknownRoots.size() > 1) {
            Collection<RepositoryAccess> commonRoots;
            while ((commonRoots = GenericSession.getCommonRootsStep(sourceRoots)) != sourceRoots) {
                sourceRoots = commonRoots;
            }
        }
        this.createRoots(sourceRoots);
        this.clearUnknownRoots(context.getBindingProperties());
    }

    public final REPO_LOCATION_TYPE getRepositoryLocation() {
        return this.m_repositoryLocation;
    }

    @Override
    public final SVN_REVISION_TYPE getRevision() {
        return this.m_revision;
    }

    public abstract SVN_REVISION_TYPE getSVNRevision(long var1, Date var3);

    @Override
    public final URI getSVNRootUrl(boolean branches) throws CoreException {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_urlLeadIn);
        if (branches) {
            bld.append("/branches");
            if (this.m_moduleBeforeBranch && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
        } else {
            bld.append("/tags");
            if (this.m_moduleBeforeTag && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
        }
        try {
            return new URI(bld.toString());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final URI getSVNUrl() throws CoreException {
        return this.getSVNUrl(null);
    }

    @Override
    public final URI getSVNUrl(String fileName) throws CoreException {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_urlLeadIn);
        if (this.m_branchOrTag == null) {
            if (this.m_trunkStructure) {
                bld.append("/trunk");
            }
            if (this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
        } else if (this.m_branchOrTag.getType() == 0) {
            bld.append("/branches");
            if (this.m_moduleBeforeBranch && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
            bld.append('/');
            bld.append(this.m_branchOrTag.getName());
            if (this.m_moduleAfterBranch && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
        } else {
            bld.append("/tags");
            if (this.m_moduleBeforeTag && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
            bld.append('/');
            bld.append(this.m_branchOrTag.getName());
            if (this.m_moduleAfterTag && this.m_module != null) {
                bld.append('/');
                bld.append(this.m_module);
            }
        }
        if (this.m_subModule != null) {
            bld.append('/');
            bld.append(this.m_subModule);
        }
        if (fileName != null) {
            bld.append('/');
            bld.append(fileName);
        }
        try {
            return new URI(bld.toString());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final boolean hasTrunkStructure() {
        return this.m_trunkStructure;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SVN_ENTRY_TYPE[] listFolder(URI url, IProgressMonitor monitor) throws CoreException {
        String key;
        String string = key = GenericCache.cacheKey(url, this.getRevision()).intern();
        synchronized (string) {
            SVN_ENTRY_TYPE[] list = this.m_cache.get(key);
            if (list != null) {
                return list;
            }
            Logger logger = CorePlugin.getLogger();
            try {
                logger.debug("Listing remote folder %s", new Object[]{key});
                list = this.innerListFolder(url, monitor);
                if (list == null || list.length == 0) {
                    logger.debug("Remote folder had no entries %s", new Object[]{key});
                    list = this.getEmptyEntryList();
                }
                this.m_cache.put(key, list);
                SVN_ENTRY_TYPE[] SVN_ENTRY_TYPEArray = list;
                return SVN_ENTRY_TYPEArray;
            }
            catch (Exception e) {
                if (SvnExceptionHandler.hasSvnException(e)) {
                    logger.debug(Messages.remote_folder_does_not_exist_0, new Object[]{key});
                    SVN_ENTRY_TYPE[] SVN_ENTRY_TYPEArray2 = this.getEmptyEntryList();
                    return SVN_ENTRY_TYPEArray2;
                }
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addUnknownRoot(Map<String, String> properties, RepositoryAccess ra) {
        Map<String, String> map = properties;
        synchronized (map) {
            String unknownRootPrefix = this.getUnknownRootPrefix();
            int maxNum = -1;
            String raStr = ra.toString();
            for (Map.Entry<String, String> entries : properties.entrySet()) {
                block6: {
                    int lastDot;
                    String key = entries.getKey();
                    if (!key.startsWith(unknownRootPrefix) || (lastDot = key.lastIndexOf(46)) < 0) continue;
                    try {
                        int keyNum = Integer.parseInt(key.substring(lastDot + 1));
                        if (maxNum >= keyNum) break block6;
                        maxNum = keyNum;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if (!entries.getValue().equals(raStr)) continue;
                return;
            }
            properties.put(String.valueOf(unknownRootPrefix) + (maxNum + 1), raStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearUnknownRoots(Map<String, String> properties) {
        Map<String, String> map = properties;
        synchronized (map) {
            Iterator<String> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                if (!key.startsWith(this.getUnknownRootPrefix())) continue;
                keys.remove();
            }
        }
    }

    protected abstract void createRoots(Collection<RepositoryAccess> var1) throws CoreException;

    protected abstract ISubversionCache<SVN_ENTRY_TYPE> getCache(Map<UUID, Object> var1);

    protected abstract SVN_ENTRY_TYPE[] getEmptyEntryList();

    protected abstract REPO_LOCATION_TYPE[] getKnownRepositories() throws CoreException;

    protected abstract String getRootUrl(REPO_LOCATION_TYPE var1);

    protected abstract String getUnknownRootPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<RepositoryAccess> getUnknownRoots(Map<String, String> properties) {
        Map<String, String> map = properties;
        synchronized (map) {
            List<RepositoryAccess> unknownRoots = null;
            for (Map.Entry<String, String> entries : properties.entrySet()) {
                RepositoryAccess ra;
                String key = entries.getKey();
                if (!key.startsWith(this.getUnknownRootPrefix())) continue;
                try {
                    ra = new RepositoryAccess(entries.getValue());
                }
                catch (URISyntaxException e) {
                    continue;
                }
                if (unknownRoots == null) {
                    unknownRoots = new ArrayList<RepositoryAccess>();
                }
                unknownRoots.add(ra);
            }
            if (unknownRoots == null) {
                unknownRoots = Collections.emptyList();
            }
            return unknownRoots;
        }
    }

    protected abstract void initializeSvn(RMContext var1, URI var2, REPO_LOCATION_TYPE var3) throws CoreException;

    protected abstract SVN_ENTRY_TYPE[] innerListFolder(URI var1, IProgressMonitor var2) throws Exception;
}

