/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.buckminster.runtime.Trivial;

public final class RepositoryAccess {
    private final URI m_svnURL;
    private final String m_user;
    private final String m_password;

    public RepositoryAccess(String str) throws URISyntaxException {
        int idx = str.indexOf(94);
        String user = null;
        String passwd = null;
        if (idx >= 0) {
            user = str.substring(idx + 1);
            str = str.substring(0, idx);
            idx = user.indexOf(64);
            if (idx >= 0) {
                passwd = user.substring(idx + 1);
                user = user.substring(0, idx);
            }
        }
        this.m_svnURL = new URI(str);
        this.m_user = user;
        this.m_password = passwd;
    }

    public RepositoryAccess(URI svnURL, String user, String password) {
        this.m_svnURL = svnURL;
        this.m_user = user;
        this.m_password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryAccess)) {
            return false;
        }
        RepositoryAccess that = (RepositoryAccess)o;
        return this.m_svnURL.equals(that.m_svnURL) && Trivial.equalsAllowNull((Object)this.m_user, (Object)that.m_user) && Trivial.equalsAllowNull((Object)this.m_password, (Object)that.m_password);
    }

    public String getPassword() {
        return this.m_password;
    }

    public URI getSvnURL() {
        return this.m_svnURL;
    }

    public String getUser() {
        return this.m_user;
    }

    public int hashCode() {
        int hash = this.m_svnURL.hashCode();
        if (this.m_user != null) {
            hash = hash * 31 + this.m_user.hashCode();
        }
        if (this.m_password != null) {
            hash = hash * 31 + this.m_password.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.m_user == null) {
            return this.m_svnURL.toString();
        }
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_svnURL.toString());
        bld.append('^');
        bld.append(this.m_user);
        if (this.m_password != null) {
            bld.append('@');
            bld.append(this.m_password);
        }
        return bld.toString();
    }
}

