/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.build.AbstractBuckminsterBuilder;
import org.eclipse.buckminster.core.build.ExternalCommandBuilderConstants;
import org.eclipse.buckminster.core.build.LauncherDefinition;
import org.eclipse.buckminster.core.helpers.StreamPump;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalCommandBuilder
extends AbstractBuckminsterBuilder
implements ExternalCommandBuilderConstants {
    private static Pattern s_extractQuotedItemPattern = Pattern.compile("^\"(.*?)(?<!\\\\)(\"|$)");
    private static Pattern s_whitespaceAndQuotationMarkPattern = Pattern.compile("\\s\"");

    /*
     * Exception decompiling
     */
    public static String getCommandLine(LauncherDefinition[] launcherDefs, String defToUse, String addArgs, IProject project, int kind) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDefinitionToUse(Map<String, String> args) {
        String s = AbstractBuckminsterBuilder.getValue(args, "launcherdefinition.to.use");
        if (s == null) {
            s = "${system:OS}";
        }
        return s;
    }

    public static LauncherDefinition[] getLauncherDefinitions(File launcherDefinitionsFile) throws CoreException {
        ArrayList<LauncherDefinition> defs = new ArrayList<LauncherDefinition>();
        if (launcherDefinitionsFile.exists()) {
            BufferedReader br = null;
            try {
                try {
                    String pattern;
                    br = new BufferedReader(new FileReader(launcherDefinitionsFile));
                    while ((pattern = br.readLine()) != null) {
                        String commandLine = br.readLine();
                        if (commandLine == null) break;
                        defs.add(new LauncherDefinition(pattern, commandLine));
                    }
                    br.close();
                }
                catch (Throwable t) {
                    throw BuckminsterException.wrap((Throwable)t);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return defs.toArray(new LauncherDefinition[0]);
    }

    public static File getLauncherDefinitionsFile(Map<String, String> args, IProject project) throws CoreException {
        Path relativePath;
        String launcherDefinitionsFile = AbstractBuckminsterBuilder.getValue(args, "launcherdefinitions.file");
        if (launcherDefinitionsFile == null || launcherDefinitionsFile.length() == 0) {
            launcherDefinitionsFile = ".launcherdefinitions";
        }
        if ((relativePath = new Path(launcherDefinitionsFile)).isAbsolute()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launcher_definitions_file_name_not_relative_to_project_root_0, (Object)launcherDefinitionsFile), (Object[])new Object[0]);
        }
        IPath fullPath = project.getLocation().append((IPath)relativePath);
        return fullPath.toFile();
    }

    @Override
    protected IProject[] doBuild(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        String addArgs;
        String defToUse;
        File launcherDefinitionsFile = ExternalCommandBuilder.getLauncherDefinitionsFile(args, this.getProject());
        LauncherDefinition[] launcherDefinitions = ExternalCommandBuilder.getLauncherDefinitions(launcherDefinitionsFile);
        String fullCommandLine = ExternalCommandBuilder.getCommandLine(launcherDefinitions, defToUse = ExternalCommandBuilder.getDefinitionToUse(args), addArgs = AbstractBuckminsterBuilder.getValue(args, "additional.arguments"), this.getProject(), kind);
        if (fullCommandLine == null) {
            throw BuckminsterException.fromMessage((String)Messages.Could_not_resolve_to_a_command_line, (Object[])new Object[0]);
        }
        Logger logger = CorePlugin.getLogger();
        logger.info(NLS.bind((String)Messages.Command_line_0, (Object)fullCommandLine), new Object[0]);
        String[] splitCommandLine = this.splitCommandLine(fullCommandLine);
        if (logger.isDebugEnabled()) {
            logger.debug("Split cmd line:", new Object[0]);
            String[] stringArray = splitCommandLine;
            int n = splitCommandLine.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                logger.debug("=> " + s, new Object[0]);
                ++n2;
            }
        }
        ProcessBuilder pb = new ProcessBuilder(splitCommandLine);
        pb.redirectErrorStream(true);
        pb.directory(launcherDefinitionsFile.getParentFile());
        try {
            Process p = pb.start();
            StreamPump thrStdOut = new StreamPump(p.getInputStream(), this.getOutStream());
            thrStdOut.start();
            thrStdOut.join();
            int exitValue = p.waitFor();
            if (exitValue != 0) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.External_command_0_exited_with_1, (Object)fullCommandLine, (Object)exitValue), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] splitCommandLine(String arg) {
        String trimmedArg = arg.trim();
        if (trimmedArg.length() == 0) {
            return Trivial.EMPTY_STRING_ARRAY;
        }
        Matcher wsAndQMmatcher = s_whitespaceAndQuotationMarkPattern.matcher(trimmedArg);
        ArrayList<String> parsed = new ArrayList<String>();
        if (trimmedArg.startsWith("\"")) {
            Matcher extractQIMatcher = s_extractQuotedItemPattern.matcher(trimmedArg);
            if (!extractQIMatcher.find()) throw new RuntimeException(Messages.Unexpected_non_match);
            parsed.add(extractQIMatcher.group(1));
            int end = extractQIMatcher.end(1);
            if (trimmedArg.length() <= end) return parsed.toArray(new String[parsed.size()]);
            Collections.addAll(parsed, this.splitCommandLine(trimmedArg.substring(end + 1)));
            return parsed.toArray(new String[parsed.size()]);
        } else if (wsAndQMmatcher.find()) {
            int end = wsAndQMmatcher.end();
            String left = trimmedArg.substring(0, wsAndQMmatcher.end() - 1);
            String right = trimmedArg.substring(end - 1);
            Collections.addAll(parsed, left.split("\\s"));
            Collections.addAll(parsed, this.splitCommandLine(right));
            return parsed.toArray(new String[parsed.size()]);
        } else {
            Collections.addAll(parsed, trimmedArg.split("\\s"));
        }
        return parsed.toArray(new String[parsed.size()]);
    }
}

