/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.FlowWithAttributes;
import org.eclipse.buckminster.core.common.parser.DocumentationParser;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Documentation
extends FlowWithAttributes
implements ISaxable {
    public static final String BM_TAG = "documentation";
    public static final String XHTML_TAG = "div";
    private static final String LEAD_IN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><div xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final String TAIL = "</div>";

    public static Documentation parse(String doc) throws CoreException {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream((LEAD_IN + doc + TAIL).getBytes("UTF-8"));
            DocumentationParser parser = new DocumentationParser();
            return (Documentation)parser.parse("generated", input);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public Documentation(ISaxableElement[] children, String[] keyNamePairs) {
        super(BM_TAG, children, keyNamePairs);
    }

    public Documentation merge(Documentation doc) {
        String[] allAttrs;
        if (doc == null) {
            return this;
        }
        ISaxableElement[] thisChildren = this.getChildren();
        ISaxableElement[] thatChildren = doc.getChildren();
        ISaxableElement[] allChildren = new ISaxableElement[thisChildren.length + thatChildren.length];
        System.arraycopy(thisChildren, 0, allChildren, 0, thisChildren.length);
        System.arraycopy(thatChildren, 0, allChildren, thisChildren.length, thatChildren.length);
        String[] thisAttrs = this.getKeyNamePairs();
        String[] thatAttrs = doc.getKeyNamePairs();
        if (thisAttrs.length == 0) {
            allAttrs = thatAttrs;
        } else if (thatAttrs.length == 0) {
            allAttrs = thisAttrs;
        } else {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            int idx = 0;
            while (idx < thisAttrs.length) {
                attrMap.put(thisAttrs[idx], thisAttrs[idx + 1]);
                idx += 2;
            }
            idx = 0;
            while (idx < thatAttrs.length) {
                attrMap.put(thatAttrs[idx], thatAttrs[idx + 1]);
                idx += 2;
            }
            ArrayList<String> attrList = new ArrayList<String>();
            for (Map.Entry entry : attrMap.entrySet()) {
                attrList.add((String)entry.getKey());
                attrList.add((String)entry.getValue());
            }
            allAttrs = attrList.toArray(new String[attrList.size()]);
        }
        return new Documentation(allChildren, allAttrs);
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.w3.org/1999/xhtml", null, XHTML_TAG);
        receiver.endDocument();
    }

    public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
        receiver.startPrefixMapping("", "http://www.w3.org/1999/xhtml");
        super.toSax(receiver, namespace, prefix, localName);
        receiver.endPrefixMapping("");
    }

    public String toString() {
        int lastIdx;
        int idx;
        String xmlContent;
        block9: {
            block8: {
                block7: {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ContentHandler serializer = Utils.newSerializer(null, (OutputStream)out, (String)"UTF-8", (int)-1, (boolean)false);
                    this.toSax(serializer);
                    xmlContent = new String(out.toByteArray(), "UTF-8");
                    idx = xmlContent.indexOf("<div");
                    if (idx >= 0) break block7;
                    return null;
                }
                int top = xmlContent.length();
                idx += XHTML_TAG.length() + 1;
                while (idx < top) {
                    if (xmlContent.charAt(idx) == '>') break;
                    ++idx;
                }
                if (idx != top) break block8;
                return null;
            }
            lastIdx = xmlContent.lastIndexOf(TAIL);
            if (lastIdx >= ++idx) break block9;
            return null;
        }
        try {
            return xmlContent.substring(idx, lastIdx);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

