/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.AbstractSplit;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Split
extends AbstractSplit {
    public static final String ATTR_LIMIT = "limit";
    private final int m_limit;

    public Split(String splitter, int limit) {
        super(splitter);
        this.m_limit = limit;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.m_limit == ((Split)((Object)o)).m_limit;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + this.m_limit;
        return hc;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        if (this.m_limit != 0) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LIMIT, (String)Integer.toString(this.m_limit));
        }
    }

    @Override
    protected List<String> checkedGetValues(Map<String, ? extends Object> properties, int recursionGuard) {
        String source = this.checkedGetSourceValue(properties, recursionGuard);
        return source == null ? Collections.emptyList() : Arrays.asList(this.getPattern().split(source, this.m_limit));
    }
}

