/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;

public class ComponentRequestBuilder
implements IComponentRequest {
    private String m_name;
    private String m_componentType;
    private VersionRange m_versionRange;
    private Filter m_filter;

    public void clear() {
        this.m_name = null;
        this.m_componentType = null;
        this.m_versionRange = null;
        this.m_filter = null;
    }

    public ComponentRequest createComponentRequest() {
        return new ComponentRequest(this);
    }

    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.m_componentType != null && !this.m_componentType.equals(id.getComponentTypeID()) || this.m_versionRange != null && !this.m_versionRange.isIncluded(id.getVersion()));
    }

    public String getComponentTypeID() {
        return this.m_componentType;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getName() {
        return this.m_name;
    }

    public VersionRange getVersionRange() {
        return this.m_versionRange;
    }

    public void initFrom(IComponentRequest request) {
        this.m_name = request.getName();
        this.m_componentType = request.getComponentTypeID();
        this.m_versionRange = request.getVersionRange();
        this.m_filter = request.getFilter();
    }

    public void setComponentTypeID(String componentType) {
        this.m_componentType = componentType;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.m_versionRange = versionRange;
    }
}

