/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.xml.sax.helpers.AttributesImpl;

public class Generator
extends NamedElement
implements IGenerator {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String ATTR_GENERATES_TYPE = "generatesType";
    public static final String ATTR_GENERATES_VERSION = "generatesVersion";
    public static final String TAG = "generator";
    private final CSpec m_cspec;
    private final String m_attribute;
    private final String m_component;
    private final String m_generatesType;
    private final Version m_generatesVersion;

    public Generator(CSpec cspec, String component, String attribute, ComponentIdentifier generates) {
        super(generates);
        this.m_cspec = cspec;
        this.m_component = component;
        this.m_attribute = attribute;
        this.m_generatesType = generates.getComponentTypeID();
        this.m_generatesVersion = generates.getVersion();
    }

    @Deprecated
    public Generator(CSpec cspec, String component, String attribute, String generates) {
        super(generates);
        this.m_cspec = cspec;
        this.m_component = component;
        this.m_attribute = attribute;
        this.m_generatesType = null;
        this.m_generatesVersion = null;
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getComponent() {
        return this.m_component;
    }

    public CSpec getCSpec() {
        return this.m_cspec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public IComponentIdentifier getGeneratedIdentifier() {
        return new ComponentIdentifier(this.getName(), this.m_generatesType, this.m_generatesVersion);
    }

    public String getGenerates() {
        return this.getName();
    }

    public String getNameAttributeName() {
        return ATTR_GENERATES;
    }

    public void registerGeneratedResolution(PathGroup[] result, IGlobalContext ctx, IProgressMonitor monitor) throws CoreException {
        Format uri;
        IPath componentLocation;
        if (result.length != 1) {
            return;
        }
        PathGroup pg = result[0];
        HashMap<String, Long> fileNames = new HashMap<String, Long>();
        pg.appendRelativeFiles(fileNames);
        if (fileNames.isEmpty()) {
            return;
        }
        Set<String> paths = fileNames.keySet();
        String readerType = "local";
        boolean isFile = false;
        if (paths.size() == 1) {
            IPath path = Path.fromOSString((String)paths.iterator().next());
            String suffix = path.getFileExtension();
            if ("zip".equals(suffix) || "jar".equals(suffix)) {
                readerType = "url.zipped";
                isFile = true;
            }
            componentLocation = pg.getBase().append(path);
        } else {
            componentLocation = pg.getBase();
        }
        try {
            uri = new Format(URLUtils.normalizeToURL((String)componentLocation.toOSString()).toString());
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        IComponentIdentifier ci = this.getGeneratedIdentifier();
        String cType = ci.getComponentTypeID();
        ResourceMap rmap = new ResourceMap(null);
        SearchPath searchPath = new SearchPath(rmap, "default");
        Provider provider = new Provider(searchPath, readerType, new String[]{cType}, null, uri, null, null, null, false, false, null, null);
        searchPath.addProvider(provider);
        rmap.addSearchPath(searchPath);
        rmap.addMatcher(new Locator(rmap, null, "default"));
        ComponentQueryBuilder query = new ComponentQueryBuilder();
        query.setRootRequest(new ComponentRequest(ci.getName(), ci.getComponentTypeID(), null));
        ResolutionContext rctx = new ResolutionContext(query.createComponentQuery());
        BOMNode node = rmap.resolve(rctx.getRootNodeQuery(), monitor);
        Resolution res = node.getResolution();
        if (res != null) {
            if (isFile) {
                componentLocation = componentLocation.removeLastSegments(1);
            }
            ctx.addGeneratedResolution(res, componentLocation);
        }
    }

    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.m_attribute);
        if (this.m_component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.m_component);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES, (String)this.getName());
        if (this.m_generatesType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_TYPE, (String)this.m_generatesType);
        }
        if (this.m_generatesVersion != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_VERSION, (String)this.m_generatesVersion.toString());
        }
    }
}

