/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends TopLevelAttribute
implements IGroup {
    public static final String ATTR_REBASE = "rebase";
    private final List<Prerequisite> m_prerequisites;
    private final IPath m_prerequisiteRebase;

    public static PathGroup[] rebase(IPath newBase, PathGroup[] pathGroups) throws CoreException {
        if (newBase == null) {
            return pathGroups;
        }
        HashMap<IPath, ArrayList<IPath>> bld = new HashMap<IPath, ArrayList<IPath>>();
        PathGroup[] pathGroupArray = pathGroups;
        int n = pathGroups.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pathGroup = pathGroupArray[n2];
            IPath currentBase = pathGroup.getBase();
            IPath[] paths = pathGroup.getPaths();
            if (paths.length == 0) {
                Group.addPathGroup(bld, newBase, currentBase, null);
            } else {
                IPath[] iPathArray = paths;
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath path = iPathArray[n4];
                    Group.addPathGroup(bld, newBase, currentBase, path);
                    ++n4;
                }
            }
            ++n2;
        }
        ArrayList<PathGroup> newPathGroups = new ArrayList<PathGroup>();
        for (Map.Entry entry : bld.entrySet()) {
            ArrayList paths = (ArrayList)entry.getValue();
            newPathGroups.add(new PathGroup((IPath)entry.getKey(), paths.toArray(new IPath[paths.size()])));
        }
        return newPathGroups.toArray(new PathGroup[newPathGroups.size()]);
    }

    private static void addPathGroup(HashMap<IPath, ArrayList<IPath>> bld, IPath newBase, IPath currentBase, IPath path) {
        IPath base;
        IPath absolute = currentBase;
        if (path != null) {
            absolute = absolute.append(path);
        }
        if (newBase.isPrefixOf(absolute)) {
            base = newBase;
            path = absolute.removeFirstSegments(newBase.segmentCount()).setDevice(null);
        } else {
            base = currentBase;
        }
        ArrayList<Object> group = bld.get(base);
        if (group == null) {
            group = new ArrayList();
            bld.put(base, group);
        }
        if (path != null) {
            group.add(path);
        }
    }

    public Group(GroupBuilder builder) {
        super(builder);
        this.m_prerequisiteRebase = builder.getPrerequisiteRebase();
        this.m_prerequisites = Utils.createUnmodifiableList(builder.getPrerequisiteList());
    }

    @Override
    public IPath getPrerequisiteRebase() {
        return this.m_prerequisiteRebase;
    }

    @Override
    public List<Prerequisite> getPrerequisites(Stack<IAttributeFilter> filters) {
        if (filters == null || filters.size() == 0 || this.m_prerequisites.size() == 0) {
            return this.m_prerequisites;
        }
        ArrayList<Prerequisite> matched = new ArrayList<Prerequisite>(this.m_prerequisites.size());
        for (Prerequisite pq : this.m_prerequisites) {
            String cname = pq.getComponentName();
            if (cname == null) {
                cname = this.getCSpec().getName();
            }
            String attr = pq.getAttribute();
            boolean isMatch = false;
            for (IAttributeFilter filter : filters) {
                if (!filter.isMatch(cname, attr)) continue;
                isMatch = true;
                break;
            }
            if (!isMatch) continue;
            matched.add(pq);
        }
        return matched.size() == this.m_prerequisites.size() ? this.m_prerequisites : matched;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isEnabled(IModelCache ctx) throws CoreException {
        if (!super.isEnabled(ctx)) {
            return false;
        }
        cspec = this.getCSpec();
        idx = this.m_prerequisites.size();
        if (idx != 0) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            if (!this.m_prerequisites.get(idx).isEnabled(ctx, cspec)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (--idx >= 0)
        }
lbl10:
        // 1 sources

        return false;
    }

    @Override
    public boolean isProducedByActions(IModelCache ctx) throws CoreException {
        CSpec cspec = this.getCSpec();
        int idx = this.m_prerequisites.size();
        while (--idx >= 0) {
            Prerequisite pq = this.m_prerequisites.get(idx);
            try {
                Attribute attr = pq.getReferencedAttribute(cspec, ctx);
                if (attr == null || !attr.isProducedByActions(ctx)) continue;
                return true;
            }
            catch (MissingComponentException e) {
                return !WorkspaceInfo.getGenerators(new ComponentRequest(pq.getComponentName(), pq.getComponentType(), null)).isEmpty();
            }
        }
        return false;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        IPath prereqsRebase = this.getPrerequisiteRebase();
        if (prereqsRebase != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REBASE, (String)prereqsRebase.toPortableString());
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createGroupBuilder();
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        for (Prerequisite pr : this.getPrerequisites()) {
            pr.toSax(handler, namespace, prefix, pr.getDefaultTag());
        }
    }

    @Override
    protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
        IPath prereqRebase = this.getPrerequisiteRebase();
        if (prereqRebase != null && !(prereqRebase = PerformManager.expandPath(local, prereqRebase)).isAbsolute()) {
            prereqRebase = this.getCSpec().getComponentLocation().append(prereqRebase);
        }
        CSpec cspec = this.getCSpec();
        ArrayList<PathGroup> bld = new ArrayList<PathGroup>();
        for (Prerequisite pr : this.getPrerequisites(filters)) {
            PathGroup[] pathGroups;
            Attribute ag;
            if (!pr.isContributor() || (ag = pr.getReferencedAttribute(cspec, ctx)) == null) continue;
            if (pr.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(pr);
                pathGroups = ag.getPathGroups(ctx, filters);
                filters.pop();
            } else {
                pathGroups = ag.getPathGroups(ctx, filters);
            }
            if (!pr.isExternal() && prereqRebase != null) {
                pathGroups = Group.rebase(prereqRebase, pathGroups);
            }
            PathGroup[] pathGroupArray = pathGroups;
            int n = pathGroups.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup path = pathGroupArray[n2];
                if (!bld.contains(path)) {
                    bld.add(path);
                }
                ++n2;
            }
        }
        return bld.toArray(new PathGroup[bld.size()]);
    }
}

