/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.actor.IActor;
import org.eclipse.buckminster.core.actor.NoSuchActorException;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ActorFactory {
    public static final String ACTOR_ID_ATTR = "ID";
    public static final String ACTOR_CLASS_ATTR = "class";
    public static final String ACTOR_NAME_ATTR = "name";
    public static final String INTERNAL_ACTION_ATTR = "action";
    public static final String INTERNAL_ACTOR_ATTR = "actor";
    private static ActorFactory s_instance = null;
    private final Map<String, String> m_fixedActionActorMappings;
    private final Map<IAction, IActor> m_liveActors = new HashMap<IAction, IActor>();

    public static synchronized ActorFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ActorFactory();
        }
        return s_instance;
    }

    private ActorFactory() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put(WellknownActions.ECLIPSE.CLEAN.toString(), "eclipse.clean");
        mappings.put(WellknownActions.ECLIPSE.BUILD.toString(), "eclipse.build");
        this.m_fixedActionActorMappings = Collections.unmodifiableMap(mappings);
    }

    public String findInternalActionActorName(String actionName) throws CoreException {
        String aname = this.m_fixedActionActorMappings.get(actionName);
        if (aname != null) {
            return aname;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.buckminster.core.internalActors");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getAttribute(INTERNAL_ACTION_ATTR).equals(actionName)) {
                return elem.getAttribute(INTERNAL_ACTOR_ATTR);
            }
            ++n2;
        }
        return null;
    }

    public synchronized IActor getActor(IAction action) throws CoreException {
        IActor actor = this.m_liveActors.get(action);
        if (actor != null) {
            return actor;
        }
        String actorName = action.getActorName();
        actor = this.internalCreateActor(actorName);
        if (actor == null) {
            throw new NoSuchActorException(actorName, action.toString());
        }
        actor.init((Action)action);
        this.m_liveActors.put(action, actor);
        return actor;
    }

    private IActor internalCreateActor(String actorName) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.buckminster.core.actors");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getAttribute(ACTOR_ID_ATTR).equals(actorName)) {
                return (IActor)elem.createExecutableExtension(ACTOR_CLASS_ATTR);
            }
            ++n2;
        }
        return null;
    }
}

