/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IActor;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.NullOutputStream;
import org.eclipse.buckminster.core.internal.actor.ActorFactory;
import org.eclipse.buckminster.core.internal.actor.GlobalContext;
import org.eclipse.buckminster.core.internal.actor.PerformContext;
import org.eclipse.buckminster.core.metadata.AmbigousComponentException;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformManager
implements IPerformManager {
    private static final PerformManager INSTANCE = new PerformManager();
    private static final PrintStream s_nullPrintStream = new PrintStream(NullOutputStream.INSTANCE);

    public static IPath expandPath(Map<String, ? extends Object> properties, IPath path) {
        if (path != null) {
            path = new Path(ExpandingProperties.expand(properties, path.toPortableString(), 0));
        }
        return path;
    }

    public static PerformManager getInstance() {
        return INSTANCE;
    }

    private static void refreshAndSetDerivedPath(IPath path, HashSet<IPath> alreadyRefreshed, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            String leaf = null;
            if (!path.hasTrailingSeparator()) {
                leaf = path.lastSegment();
                path = path.removeLastSegments(1).addTrailingSeparator();
            }
            if (alreadyRefreshed.contains(path)) {
                return;
            }
            alreadyRefreshed.add(path);
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
            if (container == null) {
                return;
            }
            if (!(container instanceof IProject)) {
                PerformManager.refreshParents(container.getParent(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            }
            container.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (leaf != null) {
                IFile file = container.getFile((IPath)new Path(leaf));
                if (file.exists()) {
                    file.setDerived(true);
                }
            } else {
                container.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        resource.setDerived(true);
                        return true;
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void refreshParents(IContainer container, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", -1);
        try {
            if (container != null) {
                if (!(container instanceof IProject)) {
                    PerformManager.refreshParents(container.getParent(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                container.refreshLocal(0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IGlobalContext perform(ICSpecData cspec, String attributeName, Map<String, ? extends Object> props, boolean forced, boolean quiet, IProgressMonitor monitor) throws CoreException {
        return this.perform(Collections.singletonList(((CSpec)cspec.getAdapter(CSpec.class)).getRequiredAttribute(attributeName)), props, forced, quiet, monitor);
    }

    @Override
    public IStatus perform(List<? extends IAttribute> attributes, IGlobalContext global, IProgressMonitor monitor) throws CoreException {
        WorkspaceInfo.pushPerformContext(global);
        try {
            IStatus iStatus = this.internalPerform(attributes, global, monitor);
            return iStatus;
        }
        finally {
            WorkspaceInfo.popPerformContext();
        }
    }

    @Override
    public IGlobalContext perform(List<? extends IAttribute> attributes, Map<String, ? extends Object> userProps, boolean forced, boolean quiet, IProgressMonitor monitor) throws CoreException {
        GlobalContext globalCtx = new GlobalContext(userProps, forced, quiet);
        monitor.beginTask(null, 1000);
        try {
            globalCtx.setStatus(this.perform(attributes, globalCtx, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900)));
            GlobalContext globalContext = globalCtx;
            return globalContext;
        }
        finally {
            globalCtx.removeScheduled(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (globalCtx.isWorkspaceRefreshPending()) {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            monitor.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addAttributeChildren(GlobalContext ctx, Attribute attribute, Set<String> seen, List<ActionInvocation> ordered, Generator attrGenerator) throws CoreException {
        if (attribute instanceof ActionArtifact) {
            attribute = ((ActionArtifact)attribute).getAction();
        }
        if (!seen.add(attrId = attribute.toString())) {
            return;
        }
        cspec = attribute.getCSpec();
        for (Prerequisite preq : attribute.getPrerequisites()) {
            try {
                ag = preq.getReferencedAttribute(cspec, ctx);
                if (ag == null) continue;
                this.addAttributeChildren(ctx, ag, seen, ordered, null);
                continue;
            }
            catch (MissingComponentException e) {
                if (preq.getComponentName() == null) {
                    cName = cspec.getName();
                    cType = cspec.getComponentTypeID();
                } else {
                    rq = cspec.getDependency(preq.getComponentName(), preq.getComponentType());
                    cName = rq.getName();
                    cType = rq.getComponentTypeID();
                }
                generators = WorkspaceInfo.getGenerators(new ComponentRequest(cName, cType, null));
                if (generators.size() == 0) {
                    throw e;
                }
                generatorCSpec = null;
                actionGenerator = null;
                ** for (generator : generators)
            }
lbl-1000:
            // 1 sources

            {
                component = generator.getComponent();
                v0 = candidate = component == null ? generator.getCSpec() : WorkspaceInfo.getResolution(new ComponentRequest(component, null, null), false).getCSpec();
                if (candidate.equals(cspec)) {
                    actionGenerator = generator;
                    generatorCSpec = candidate;
                    break;
                }
                if (generatorCSpec != null) {
                    throw new AmbigousComponentException(generator.getComponent());
                }
                actionGenerator = generator;
                generatorCSpec = candidate;
                continue;
            }
lbl37:
            // 2 sources

            ag = generatorCSpec.getAttribute(actionGenerator.getAttribute());
            this.addAttributeChildren(ctx, ag, seen, ordered, actionGenerator);
            ordered.add(new DeferredActionInvocation(cspec, preq));
        }
        if (attribute instanceof Action) {
            action = (Action)attribute;
            ordered.add(attrGenerator == null ? new DirectActionInvocation(action) : new GeneratorInvocation(attrGenerator, action));
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<ActionInvocation> getOrderedActionList(GlobalContext ctx, List<? extends IAttribute> attributes) throws CoreException {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<ActionInvocation> ordered = new ArrayList<ActionInvocation>();
        for (IAttribute iAttribute : attributes) {
            this.addAttributeChildren(ctx, (Attribute)iAttribute, seen, ordered, null);
        }
        for (IAttribute iAttribute : attributes) {
            void var5_10;
            String attrId;
            if (iAttribute instanceof IActionArtifact) {
                Action action = ((ActionArtifact)iAttribute).getAction();
            }
            if (seen.contains(attrId = var5_10.toString())) continue;
            seen.add(attrId);
            if (!(var5_10 instanceof Action)) continue;
            ordered.add(new DirectActionInvocation((Action)var5_10));
        }
        return ordered;
    }

    private IStatus internalPerform(List<? extends IAttribute> attributes, IGlobalContext global, IProgressMonitor monitor) throws CoreException {
        MultiStatus status;
        GlobalContext globalCtx = (GlobalContext)global;
        List<ActionInvocation> actionList = this.getOrderedActionList(globalCtx, attributes);
        monitor.beginTask(null, 100 * actionList.size());
        Logger logger = CorePlugin.getLogger();
        if (logger.isDebugEnabled()) {
            StringBuilder bld = new StringBuilder(40 + actionList.size() * 40);
            bld.append(Messages.Actions_to_perform_in_order);
            for (ActionInvocation action : actionList) {
                bld.append("\n  ");
                action.toString(bld);
            }
            logger.debug(bld.toString(), new Object[0]);
        }
        MultiStatus retStatus = new MultiStatus(CorePlugin.getID(), 0, "", null);
        block6: for (ActionInvocation action : actionList) {
            IStatus status2 = action.execute(globalCtx, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            switch (status2.getSeverity()) {
                case 1: 
                case 2: {
                    retStatus.add(status2);
                }
                case 0: {
                    break;
                }
                case 4: {
                    retStatus.add(status2);
                }
                default: {
                    break block6;
                }
            }
        }
        IStatus[] children = retStatus.getChildren();
        Object object = status = children.length == 1 ? children[0] : retStatus;
        if (status.getSeverity() == 4) {
            throw new CoreException((IStatus)status);
        }
        return status;
    }

    abstract class ActionInvocation {
        ActionInvocation() {
        }

        abstract IStatus execute(GlobalContext var1, IProgressMonitor var2) throws CoreException;

        abstract void toString(StringBuilder var1);
    }

    class DeferredActionInvocation
    extends ActionInvocation {
        private final CSpec m_requestor;
        private final Prerequisite m_prerequisite;

        public DeferredActionInvocation(CSpec requestor, Prerequisite prerequisite) {
            this.m_requestor = requestor;
            this.m_prerequisite = prerequisite;
        }

        IStatus execute(GlobalContext globalCtx, IProgressMonitor monitor) throws CoreException {
            CSpec referenced = this.m_prerequisite.getReferencedCSpec(this.m_requestor, globalCtx);
            if (referenced == null) {
                return Status.OK_STATUS;
            }
            Attribute attr = referenced.getRequiredAttribute(this.m_prerequisite.getName());
            Filter filter = attr.getFilter();
            if (filter != null && !filter.match(globalCtx.getProperties())) {
                return Status.OK_STATUS;
            }
            return PerformManager.this.internalPerform(Collections.singletonList(attr), globalCtx, monitor);
        }

        void toString(StringBuilder bld) {
            bld.append("Deferred invocation of ");
            bld.append(this.m_prerequisite);
        }
    }

    class DirectActionInvocation
    extends ActionInvocation {
        private final Action m_action;
        private PerformContext m_performContext;

        DirectActionInvocation(Action action) {
            this.m_action = action;
        }

        IStatus execute(GlobalContext globalCtx, IProgressMonitor monitor) throws CoreException {
            PrintStream err;
            PrintStream out;
            if (this.m_action.isAssignConsoleSupport()) {
                out = Logger.getOutStream();
                err = Logger.getErrStream();
            } else {
                out = s_nullPrintStream;
                err = s_nullPrintStream;
            }
            MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
            this.m_performContext = new PerformContext(globalCtx, this.m_action, out, err, monitor);
            if (globalCtx.hasPerformedAction(this.m_action)) {
                MonitorUtils.done((IProgressMonitor)monitor);
                return Status.OK_STATUS;
            }
            globalCtx.addPerformedAction(this.m_action);
            if (!this.m_performContext.isForced() && this.m_action.isUpToDate(this.m_performContext)) {
                MonitorUtils.done((IProgressMonitor)monitor);
                return Status.OK_STATUS;
            }
            IActor actor = ActorFactory.getInstance().getActor(this.m_action);
            IStatus status = actor.perform(this.m_performContext, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 4));
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            if (status.getSeverity() != 4) {
                this.makeWorkspaceAwareOfProducts(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            }
            MonitorUtils.done((IProgressMonitor)monitor);
            return status;
        }

        Action getAction() {
            return this.m_action;
        }

        PerformContext getPerformContext() {
            return this.m_performContext;
        }

        void toString(StringBuilder bld) {
            this.m_action.toString(bld);
        }

        private void makeWorkspaceAwareOfProducts(IProgressMonitor monitor) throws CoreException {
            Action action = this.getAction();
            PathGroup[] pathGroups = action.getPathGroups(this.m_performContext, null);
            int ticks = 100 * pathGroups.length;
            monitor.beginTask(null, ticks);
            try {
                HashSet alreadyRefreshed = new HashSet();
                PathGroup[] pathGroupArray = pathGroups;
                int n = pathGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    PathGroup pathGroup = pathGroupArray[n2];
                    IProgressMonitor groupMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
                    IPath[] paths = pathGroup.getPaths();
                    groupMonitor.beginTask(null, 10 * paths.length);
                    IPath base = pathGroup.getBase();
                    IPath[] iPathArray = paths;
                    int n3 = paths.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPath path = iPathArray[n4];
                        PerformManager.refreshAndSetDerivedPath(path.isAbsolute() ? path : base.append(path), alreadyRefreshed, MonitorUtils.subMonitor((IProgressMonitor)groupMonitor, (int)10));
                        ++n4;
                    }
                    groupMonitor.done();
                    ++n2;
                }
            }
            finally {
                MonitorUtils.done((IProgressMonitor)monitor);
            }
        }
    }

    class GeneratorInvocation
    extends DirectActionInvocation {
        private final Generator m_generator;

        public GeneratorInvocation(Generator generator, Action generatorAction) {
            super(generatorAction);
            this.m_generator = generator;
        }

        IStatus execute(GlobalContext globalCtx, IProgressMonitor monitor) throws CoreException {
            IStatus status = super.execute(globalCtx, monitor);
            if (status.getSeverity() == 4) {
                return status;
            }
            this.m_generator.registerGeneratedResolution(this.getAction().getPathGroups(this.getPerformContext(), null), globalCtx, monitor);
            return status;
        }
    }
}

