/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.download.Installer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class MaterializerEndPoint {
    private final IPath m_finalDestination;
    private final Installer m_installer;

    public static MaterializerEndPoint create(IPath location, String remoteName, Resolution resolution, MaterializationContext ctx) throws CoreException {
        String suffixedName = ctx.getSuffixedName(resolution, remoteName);
        Installer installer = suffixedName == null ? Installer.getPlainInstaller() : Installer.getInstaller((String)suffixedName, (resolution.isUnpack() || ctx.getMaterializationSpec().isExpand(resolution) ? 1 : 0) != 0);
        return new MaterializerEndPoint(location, installer);
    }

    MaterializerEndPoint(IPath finalLocation, Installer installer) {
        this.m_finalDestination = finalLocation;
        this.m_installer = installer;
    }

    public IPath getFinalDestination() {
        return this.m_finalDestination;
    }

    public void unpack(InputStream input, IProgressMonitor monitor) throws IOException, CoreException {
        this.m_installer.install(input, this.m_finalDestination.toFile(), monitor);
    }
}

