/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.opml.IOPML;
import org.eclipse.buckminster.opml.builder.OPMLBuilder;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionBuilder
implements IResolution {
    private String m_artifactInfo;
    private final List<String> m_attributes = new ArrayList<String>();
    private VersionSelector m_branchOrTag;
    private String m_componentTypeId;
    private String m_contentType;
    private final CSpecBuilder m_cspec;
    private long m_lastModified;
    private boolean m_materializable = true;
    private String m_remoteName;
    private OPMLBuilder m_opml;
    private Provider m_provider;
    private String m_readerTypeId;
    private String m_repository;
    private final ComponentRequestBuilder m_request = new ComponentRequestBuilder();
    private Filter m_resolutionFilter;
    private long m_revision;
    private long m_size = -1L;
    private Date m_timestamp;
    private boolean m_unpack = false;
    private String m_persistentId;

    public ResolutionBuilder() {
        this(new CSpecBuilder(), null);
    }

    public ResolutionBuilder(CSpecBuilder cspecBuilder, OPMLBuilder opmlBuilder) {
        this.m_cspec = cspecBuilder;
        this.m_opml = opmlBuilder;
    }

    public void addAttribute(String attribute) {
        this.m_attributes.add(attribute);
    }

    public void clear() {
        this.m_artifactInfo = null;
        this.m_attributes.clear();
        this.m_branchOrTag = null;
        this.m_componentTypeId = null;
        this.m_contentType = null;
        this.m_cspec.clear();
        this.m_lastModified = 0L;
        this.m_materializable = true;
        this.m_remoteName = null;
        this.m_opml = null;
        this.m_provider = null;
        this.m_readerTypeId = null;
        this.m_repository = null;
        this.m_request.clear();
        this.m_resolutionFilter = null;
        this.m_revision = 0L;
        this.m_size = -1L;
        this.m_timestamp = null;
        this.m_unpack = false;
    }

    @Override
    public String getArtifactInfo() {
        return this.m_artifactInfo;
    }

    @Override
    public List<String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public String getComponentTypeId() {
        return this.m_componentTypeId;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    @Override
    public CSpec getCSpec() {
        return this.m_cspec.createCSpec();
    }

    public CSpecBuilder getCSpecBuilder() {
        return this.m_cspec;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public VersionSelector getMatchedBranchOrTag() {
        return this.m_branchOrTag;
    }

    public OPML getOPML() {
        return this.m_opml == null ? null : new OPML(this.m_opml);
    }

    public OPMLBuilder getOPMLBuilder() {
        if (this.m_opml == null) {
            this.m_opml = new OPMLBuilder();
        }
        return this.m_opml;
    }

    @Override
    public String getPersistentId() {
        return this.m_persistentId;
    }

    @Override
    public Provider getProvider() {
        if (this.m_provider == null) {
            String componentType = this.m_cspec.getComponentTypeID();
            if (componentType == null) {
                componentType = "unknown";
            }
            return new Provider(this.m_readerTypeId, new String[]{componentType}, this.m_repository, this.m_resolutionFilter);
        }
        return this.m_provider;
    }

    @Override
    public String getReaderTypeId() {
        return this.m_readerTypeId;
    }

    public String getRemoteName() {
        return this.m_remoteName;
    }

    @Override
    public String getRepository() {
        return this.m_repository;
    }

    @Override
    public ComponentRequestBuilder getRequest() {
        return this.m_request;
    }

    @Override
    public Filter getResolutionFilter() {
        return this.m_resolutionFilter;
    }

    @Override
    public long getSelectedRevision() {
        return this.m_revision;
    }

    @Override
    public Date getSelectedTimestamp() {
        return this.m_timestamp;
    }

    public long getSize() {
        return this.m_size;
    }

    @Override
    public VersionMatch getVersionMatch() {
        return new VersionMatch(this.m_cspec.getVersion(), this.m_branchOrTag, this.m_revision, this.m_timestamp, this.m_artifactInfo);
    }

    public void initFrom(IResolution resolution) throws CoreException {
        this.clear();
        this.m_attributes.addAll(resolution.getAttributes());
        this.m_componentTypeId = resolution.getComponentTypeId();
        this.m_contentType = resolution.getContentType();
        this.m_cspec.initFrom(resolution.getCSpec());
        this.m_lastModified = resolution.getLastModified();
        this.m_materializable = resolution.isMaterializable();
        IOPML opml = resolution.getOPML();
        if (opml != null) {
            this.m_opml = new OPMLBuilder();
            this.m_opml.initFrom(opml);
        }
        this.m_persistentId = resolution.getPersistentId();
        this.m_provider = resolution.getProvider();
        this.m_resolutionFilter = resolution.getResolutionFilter();
        this.m_remoteName = resolution.getRemoteName();
        this.m_repository = resolution.getRepository();
        this.m_request.initFrom(resolution.getRequest());
        this.m_size = resolution.getSize();
        this.m_artifactInfo = resolution.getArtifactInfo();
        this.m_branchOrTag = resolution.getMatchedBranchOrTag();
        this.m_revision = resolution.getSelectedRevision();
        this.m_timestamp = resolution.getSelectedTimestamp();
        this.m_unpack = resolution.isUnpack();
    }

    @Override
    public boolean isMaterializable() {
        return this.m_materializable;
    }

    @Override
    public boolean isUnpack() {
        return this.m_unpack;
    }

    public void setArtifactInfo(String artifactInfo) {
        this.m_artifactInfo = artifactInfo;
    }

    public void setAttributes(List<String> attributes) {
        this.m_attributes.clear();
        if (attributes != null) {
            this.m_attributes.addAll(attributes);
        }
    }

    public void setBranchOrTag(VersionSelector branchOrTag) {
        this.m_branchOrTag = branchOrTag;
    }

    public void setComponentTypeId(String componentTypeId) {
        this.m_componentTypeId = componentTypeId;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public void setFileInfo(IFileInfo info) {
        if (info == null) {
            this.setContentType(null);
            this.setRemoteName(null);
            this.setLastModified(0L);
            this.setSize(-1L);
        } else {
            this.setContentType(info.getContentType());
            this.setRemoteName(info.getRemoteName());
            this.setLastModified(info.getLastModified());
            this.setSize(info.getSize());
        }
    }

    public void setLastModified(long lastModified) {
        this.m_lastModified = lastModified;
    }

    public void setMaterializable(boolean materializable) {
        this.m_materializable = materializable;
    }

    public void setPersistentId(String persistentId) {
        this.m_persistentId = persistentId;
    }

    public void setProvider(Provider provider) {
        this.m_provider = provider;
    }

    public void setReaderTypeId(String readerTypeId) {
        this.m_readerTypeId = readerTypeId;
    }

    public void setRemoteName(String remoteName) {
        this.m_remoteName = remoteName;
    }

    public void setRepository(String repository) {
        this.m_repository = repository;
    }

    public void setResolutionFilter(Filter resolutionFilter) {
        this.m_resolutionFilter = resolutionFilter;
    }

    public void setRevision(long revision) {
        this.m_revision = revision;
    }

    public void setSize(long size) {
        this.m_size = size;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setUnpack(boolean unpack) {
        this.m_unpack = unpack;
    }

    public void setVersionMatch(VersionMatch versionMatch) {
        if (versionMatch == null) {
            this.m_artifactInfo = null;
            this.m_branchOrTag = null;
            this.m_revision = 0L;
            this.m_timestamp = null;
        } else {
            this.m_artifactInfo = versionMatch.getArtifactInfo();
            this.m_branchOrTag = versionMatch.getBranchOrTag();
            this.m_revision = versionMatch.getRevision();
            this.m_timestamp = versionMatch.getTimestamp();
        }
    }
}

