/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceBinding
extends Materialization
implements Comparable<WorkspaceBinding> {
    public static final int SEQUENCE_NUMBER = 1;
    public static final String TAG = "workspaceBinding";
    public static final String ATTR_WS_RELATIVE_PATH = "workspaceRelativePath";
    public static final String ATTR_WS_LOCATION = "workspaceLocation";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_RESOLUTION_ID = "resolutionId";
    private final long m_timestamp;
    private final IPath m_workspaceRoot;
    private final IPath m_workspaceRelativePath;
    private final Map<String, String> m_properties;
    private final UUID m_resolutionId;
    private static long s_lastTS = System.currentTimeMillis();

    public static long getNextTimestamp() {
        long now = System.currentTimeMillis();
        if (now > s_lastTS) {
            s_lastTS = now;
        } else {
            now = ++s_lastTS;
        }
        return now;
    }

    public WorkspaceBinding(IPath componentLocation, ComponentIdentifier cid, UUID resId, IPath workspaceRoot, IPath workspaceRelativePath, Map<String, String> properties, long timestamp) {
        super(componentLocation, cid);
        this.m_resolutionId = resId;
        this.m_timestamp = timestamp;
        this.m_workspaceRoot = workspaceRoot;
        this.m_workspaceRelativePath = workspaceRelativePath;
        this.m_properties = ExpandingProperties.createUnmodifiableProperties(properties);
    }

    public WorkspaceBinding(IPath componentLocation, Resolution res, IPath workspaceRoot, IPath workspaceRelativePath, Map<String, String> properties) {
        this(componentLocation, res.getComponentIdentifier(), res.getId(), workspaceRoot, workspaceRelativePath, properties, WorkspaceBinding.getNextTimestamp());
    }

    @Override
    public int compareTo(WorkspaceBinding o) {
        return this.m_timestamp < o.m_timestamp ? -1 : (this.m_timestamp == o.m_timestamp ? 0 : 1);
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    public Materialization getMaterialization() {
        return new Materialization(this.getComponentLocation(), this.getComponentIdentifier());
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public Resolution getResolution(StorageManager sm) throws CoreException {
        return sm.getResolutions().getElement(this.m_resolutionId);
    }

    public IPath getWorkspaceRelativePath() {
        return this.m_workspaceRelativePath;
    }

    public IPath getWorkspaceRoot() {
        return this.m_workspaceRoot;
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getWorkspaceBindings().contains(this);
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        sm.getWorkspaceBindings().removeElement(this.getId());
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getWorkspaceBindings().putElement(this);
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WS_RELATIVE_PATH, (String)this.m_workspaceRelativePath.toPortableString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WS_LOCATION, (String)this.m_workspaceRoot.toPortableString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)Long.toString(this.m_timestamp));
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_ID, (String)this.m_resolutionId.toString());
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        super.emitElements(receiver, namespace, prefix);
        SAXEmitter.emitProperties(receiver, this.m_properties, namespace, prefix, true, false);
    }
}

