/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.parser.IDWrapperHandler;
import org.eclipse.buckminster.core.metadata.parser.VersionMatchHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ResolutionHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "resolution";
    private final ComponentRequestHandler m_componentRequestHandler = new ComponentRequestHandler((AbstractHandler)this, new ComponentRequestBuilder());
    private final VersionMatchHandler m_versionMatchHandler = new VersionMatchHandler((AbstractHandler)this);
    private final ArrayList<String> m_attributes = new ArrayList();
    private UUID m_cspecId;
    private UUID m_opmlId;
    private UUID m_providerId;
    private ComponentRequest m_request;
    private String m_componentType;
    private VersionMatch m_versionMatch;
    private boolean m_materializable;
    private String m_persistentId;
    private String m_repository;
    private String m_remoteName;
    private String m_contentType;
    private long m_lastModified;
    private long m_size;
    private boolean m_unpack;

    public ResolutionHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_componentRequestHandler) {
            this.m_request = this.m_componentRequestHandler.getBuilder().createComponentRequest();
        } else if (child == this.m_versionMatchHandler) {
            this.m_versionMatch = this.m_versionMatchHandler.getVersionMatch();
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = "request".equals(localName) ? this.m_componentRequestHandler : ("versionMatch".equals(localName) ? this.m_versionMatchHandler : super.createHandler(uri, localName, attrs));
        return ch;
    }

    public Resolution getResolution() throws SAXException {
        Provider provider;
        CSpec cspec;
        if (this.m_request == null) {
            throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.request"), this.getDocumentLocator());
        }
        if (this.m_versionMatch == null) {
            throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.versionMatch"), this.getDocumentLocator());
        }
        if (this.m_componentType == null) {
            this.m_componentType = this.legacyComponentType();
        }
        AbstractHandler parent = this.getParentHandler();
        OPML opml = null;
        if (parent instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (CSpec)wh.getWrapped(this.m_cspecId);
            provider = (Provider)wh.getWrapped(this.m_providerId);
            if (this.m_opmlId != null) {
                opml = (OPML)wh.getWrapped(this.m_opmlId);
            }
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.m_cspecId);
                provider = sm.getProviders().getElement(this.m_providerId);
                if (this.m_opmlId != null) {
                    opml = sm.getOPMLs().getElement(this.m_opmlId);
                }
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        return new Resolution(cspec, opml, this.m_componentType, this.m_versionMatch, provider, this.m_materializable, this.m_request, this.m_attributes, this.m_persistentId, this.m_repository, this.m_remoteName, this.m_contentType, this.m_lastModified, this.m_size, this.m_unpack);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_versionMatch = null;
        this.m_cspecId = UUID.fromString(this.getStringValue(attrs, "cspecId"));
        this.m_materializable = this.getBooleanValue(attrs, "materializable");
        this.m_providerId = UUID.fromString(this.getStringValue(attrs, "providerId"));
        String tmp = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"opmlId");
        this.m_opmlId = tmp == null ? null : UUID.fromString(tmp);
        this.m_componentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        this.m_persistentId = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"persistentId");
        this.m_repository = this.getStringValue(attrs, "repository");
        this.m_remoteName = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"remoteName");
        this.m_contentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"contentType");
        this.m_size = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"size", (long)-1L);
        this.m_lastModified = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"lastModified", (long)-1L);
        this.m_unpack = ResolutionHandler.getOptionalBooleanValue((Attributes)attrs, (String)"unpack", (boolean)false);
        this.m_request = null;
        this.m_attributes.clear();
        String attributes = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"attributes");
        if (attributes != null) {
            String[] stringArray = attributes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (!this.m_attributes.contains(attr)) {
                    this.m_attributes.add(attr);
                }
                ++n2;
            }
        }
    }

    private String legacyComponentType() throws SAXException {
        Provider provider;
        ICSpecData cspec;
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (ICSpecData)wh.getWrapped(this.m_cspecId);
            provider = (Provider)wh.getWrapped(this.m_providerId);
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.m_cspecId);
                provider = sm.getProviders().getElement(this.m_providerId);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        String[] ctypeIDs = provider.getComponentTypeIDs();
        if (ctypeIDs.length == 1) {
            return ctypeIDs[0];
        }
        String ctype = cspec.getComponentIdentifier().getComponentTypeID();
        if (ctype != null) {
            return ctype;
        }
        if (ctypeIDs.length == 3 && ctypeIDs[0].equals("osgi.bundle") && ctypeIDs[1].equals("eclipse.feature") && ctypeIDs[2].equals("buckminster")) {
            return "buckminster";
        }
        return "unknown";
    }
}

