/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.Date;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class VersionMatchHandler
extends ExtensionAwareHandler {
    public static final String TAG = "versionMatch";
    private VersionMatch m_versionMatch;

    VersionMatchHandler(AbstractHandler parent) {
        super(parent);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        try {
            Version version = VersionHelper.parseVersionAttributes(attrs);
            VersionSelector branchOrTag = null;
            String tmp = VersionMatchHandler.getOptionalStringValue((Attributes)attrs, (String)"branchOrTag");
            if (tmp != null) {
                branchOrTag = VersionSelector.fromString(tmp);
            }
            long revision = VersionMatchHandler.getOptionalLongValue((Attributes)attrs, (String)"revision", (long)-1L);
            Date timestamp = null;
            tmp = VersionMatchHandler.getOptionalStringValue((Attributes)attrs, (String)"timestamp");
            if (tmp != null) {
                timestamp = DateAndTimeUtils.fromISOFormat(tmp);
            }
            String artifactInfo = VersionMatchHandler.getOptionalStringValue((Attributes)attrs, (String)"artifactInfo");
            this.m_versionMatch = new VersionMatch(version, branchOrTag, revision, timestamp, artifactInfo);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), e);
        }
    }

    VersionMatch getVersionMatch() {
        return this.m_versionMatch;
    }
}

