/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentQueryBuilder
implements IComponentQuery {
    private final ArrayList<AdvisorNodeBuilder> m_advisorNodes = new ArrayList();
    private final ComponentRequestBuilder m_rootRequest = new ComponentRequestBuilder();
    private Documentation m_documentation;
    private Map<String, String> m_properties;
    private URL m_contextURL;
    private String m_propertiesURL;
    private String m_resourceMapURL;
    private String m_shortDesc;

    public AdvisorNodeBuilder addAdvisorNode() {
        AdvisorNodeBuilder node = new AdvisorNodeBuilder();
        this.m_advisorNodes.add(node);
        return node;
    }

    public void addAdvisorNode(AdvisorNodeBuilder node) {
        this.m_advisorNodes.add(node);
    }

    public void clear() {
        this.m_rootRequest.clear();
        this.m_advisorNodes.clear();
        this.m_contextURL = null;
        this.m_properties = null;
        this.m_propertiesURL = null;
        this.m_resourceMapURL = null;
        this.m_documentation = null;
        this.m_shortDesc = null;
    }

    public ComponentQuery createComponentQuery() {
        return new ComponentQuery(this);
    }

    public List<AdvisorNodeBuilder> getAdvisoryNodes() {
        return this.m_advisorNodes;
    }

    @Override
    public URL getContextURL() {
        return this.m_contextURL;
    }

    @Override
    public Map<String, String> getDeclaredProperties() {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, String>();
        }
        return this.m_properties;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public AdvisorNodeBuilder getNodeByCriteria(Pattern pattern, String componentType, Filter filter) {
        for (AdvisorNodeBuilder node : this.m_advisorNodes) {
            if (!Trivial.equalsAllowNull((Object)node.getNamePattern(), (Object)pattern) || !Trivial.equalsAllowNull((Object)node.getComponentTypeID(), (Object)componentType) || !Trivial.equalsAllowNull((Object)node.getFilter(), (Object)filter)) continue;
            return node;
        }
        return null;
    }

    @Override
    @Deprecated
    public AdvisorNodeBuilder getNodeByPattern(String pattern, String componentType) {
        for (AdvisorNodeBuilder node : this.m_advisorNodes) {
            if (!node.getNamePattern().toString().equals(pattern) || !Trivial.equalsAllowNull((Object)node.getComponentTypeID(), (Object)componentType)) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getPropertiesURL() {
        return this.m_propertiesURL;
    }

    @Override
    public String getResourceMapURL() {
        return this.m_resourceMapURL;
    }

    @Override
    public ComponentRequest getRootRequest() {
        return this.m_rootRequest.createComponentRequest();
    }

    public ComponentRequestBuilder getRootRequestBuilder() {
        return this.m_rootRequest;
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    public void initFrom(IComponentQuery query) {
        this.clear();
        for (IAdvisorNode iAdvisorNode : query.getAdvisoryNodes()) {
            AdvisorNodeBuilder bld = new AdvisorNodeBuilder();
            bld.initFrom(iAdvisorNode);
            this.m_advisorNodes.add(bld);
        }
        Map<String, String> map = query.getDeclaredProperties();
        if (map.size() > 0) {
            this.m_properties = new HashMap<String, String>(map);
        }
        this.m_contextURL = query.getContextURL();
        this.m_propertiesURL = query.getPropertiesURL();
        this.m_resourceMapURL = query.getResourceMapURL();
        this.m_rootRequest.initFrom(query.getRootRequest());
        this.m_documentation = query.getDocumentation();
        this.m_shortDesc = query.getShortDesc();
    }

    public void removeAdvisorNode(AdvisorNodeBuilder node) {
        this.m_advisorNodes.remove(node);
    }

    public final void setContextURL(URL contextURL) {
        this.m_contextURL = contextURL;
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void setPlatformAgnostic(boolean flag) {
        if (!flag) {
            if (this.m_properties == null) {
                return;
            }
            this.m_properties.remove("target.os");
            this.m_properties.remove("target.ws");
            this.m_properties.remove("target.arch");
            this.m_properties.remove("target.nl");
            if (this.m_properties.size() == 0) {
                this.m_properties = null;
            }
        } else {
            Map<String, String> props = this.getDeclaredProperties();
            props.put("target.os", "*");
            props.put("target.ws", "*");
            props.put("target.arch", "*");
            props.put("target.nl", "*");
        }
    }

    public final void setPropertiesURL(String propertiesURL) {
        this.m_propertiesURL = propertiesURL;
    }

    public final void setResourceMapURL(String resourceMapURL) {
        this.m_resourceMapURL = resourceMapURL;
    }

    public final void setRootRequest(IComponentRequest rootRequest) {
        this.m_rootRequest.initFrom(rootRequest);
    }

    public void setShortDesc(String shortDesc) {
        this.m_shortDesc = shortDesc;
    }
}

