/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteReader
extends AbstractCatalogReader {
    protected AbstractRemoteReader(IReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super(readerType, rInfo);
    }

    /*
     * Loose catch block
     */
    @Override
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        InputStream input = null;
        try {
            input = CorePlugin.getDefault().openCachedRemoteFile(this, fileName, monitor);
        }
        catch (FileNotFoundException e) {
            IOUtils.close(input);
            return false;
        }
        catch (IOException e2) {
            throw BuckminsterException.wrap((Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
            }
        }
        IOUtils.close((Closeable)input);
        return true;
    }

    @Override
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        T t;
        InputStream input = null;
        monitor.beginTask(fileName, 2000);
        try {
            input = CorePlugin.getDefault().openCachedRemoteFile(this, fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            t = consumer.consumeStream(this, String.valueOf(this.toString()) + ',' + fileName, input, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        monitor.done();
        return t;
    }
}

