/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.resolver.IResolverFactory;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;

public class ResolverFactoryMaintainer
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String QUERY_RESOLVERS_POINT = "org.eclipse.buckminster.core.queryResolvers";
    static final String FACTORY_ELEM = "factory";
    private static final ResolverFactoryMaintainer s_instance = new ResolverFactoryMaintainer();
    private IResolverFactory[] m_resolverFactories;

    static {
        BuckminsterPreferences.addListener((IEclipsePreferences.IPreferenceChangeListener)s_instance);
    }

    private static IResolverFactory[] createFactoriesByExtension() {
        Logger logger = CorePlugin.getLogger();
        IConfigurationElement[] elems = Platform.getExtensionRegistry().getConfigurationElementsFor(QUERY_RESOLVERS_POINT);
        ArrayList<IResolverFactory> factories = new ArrayList<IResolverFactory>(elems.length);
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                IResolverFactory factory = (IResolverFactory)elem.createExecutableExtension(FACTORY_ELEM);
                factories.add(factory);
            }
            catch (CoreException e) {
                logger.error((Throwable)e, NLS.bind((String)Messages.Unable_to_instantiate_Query_Resolver_Factory_0, (Object)elem.getAttribute("id")), new Object[0]);
            }
            ++n2;
        }
        return factories.toArray(new IResolverFactory[factories.size()]);
    }

    public static ResolverFactoryMaintainer getInstance() {
        return s_instance;
    }

    public static String[] getRegisterFactoryIDs() {
        IConfigurationElement[] elems = Platform.getExtensionRegistry().getConfigurationElementsFor(QUERY_RESOLVERS_POINT);
        int idx = elems.length;
        String[] factoryIDs = new String[idx];
        while (--idx >= 0) {
            factoryIDs[idx] = elems[idx].getAttribute("id");
        }
        return factoryIDs;
    }

    public IResolverFactory[] getActiveResolverFactories() {
        IResolverFactory[] allFactories = this.getResolverFactories();
        HashMap<String, IResolverFactory> factoriesById = new HashMap<String, IResolverFactory>();
        IResolverFactory[] iResolverFactoryArray = allFactories;
        int n = allFactories.length;
        int n2 = 0;
        while (n2 < n) {
            IResolverFactory factory = iResolverFactoryArray[n2];
            factoriesById.put(factory.getId(), factory);
            ++n2;
        }
        String[] sortOrder = BuckminsterPreferences.getQueryResolverSortOrder();
        int numFactories = sortOrder.length;
        ArrayList<IResolverFactory> factories = new ArrayList<IResolverFactory>(numFactories);
        String[] stringArray = sortOrder;
        int n3 = sortOrder.length;
        int n4 = 0;
        while (n4 < n3) {
            String factoryName = stringArray[n4];
            IResolverFactory factory = (IResolverFactory)factoriesById.remove(factoryName);
            if (factory != null) {
                factories.add(factory);
            }
            ++n4;
        }
        return factories.toArray(new IResolverFactory[factories.size()]);
    }

    public synchronized IResolverFactory[] getResolverFactories() {
        if (this.m_resolverFactories == null) {
            IResolverFactory[] fcs = ResolverFactoryMaintainer.createFactoriesByExtension();
            this.m_resolverFactories = fcs;
            if (!BuckminsterPreferences.isCustomQuerySortOrder()) {
                this.setDefaultResolutionOrder();
                this.m_resolverFactories = fcs;
            }
        }
        return this.m_resolverFactories;
    }

    public synchronized void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("queryResolverSortOrder".equals(event.getKey())) {
            this.m_resolverFactories = null;
        }
    }

    public void setDefaultResolutionOrder() {
        TreeMap<Integer, String> activeFactories = new TreeMap<Integer, String>();
        IResolverFactory[] iResolverFactoryArray = this.getResolverFactories();
        int n = iResolverFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResolverFactory factory = iResolverFactoryArray[n2];
            int prio = factory.getResolutionPriority();
            if (prio >= 0) {
                activeFactories.put(new Integer(prio), factory.getId());
            }
            ++n2;
        }
        BuckminsterPreferences.setQueryResolverSortOrder((String[])activeFactories.values().toArray(new String[activeFactories.size()]));
        BuckminsterPreferences.setCustomQueryResolverSortOrder((boolean)false);
    }

    public synchronized void setResolverFactories(IResolverFactory[] resolverFactories) {
        this.m_resolverFactories = resolverFactories;
    }
}

