/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.rmap.model.TransformerMismatchException;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BidirectionalTransformer
extends AbstractSaxableElement {
    public static final String TAG = "transform";
    public static final String ATTR_TO_PATTERN = "toPattern";
    public static final String ATTR_TO_REPLACEMENT = "toReplacement";
    public static final String ATTR_FROM_PATTERN = "fromPattern";
    public static final String ATTR_FROM_REPLACEMENT = "fromReplacement";
    private final Pattern m_toPattern;
    private final String m_toReplacement;
    private final Pattern m_fromPattern;
    private final String m_fromReplacement;

    private static String replace(String source, Pattern pattern, String replacement) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, replacement);
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    public BidirectionalTransformer(Pattern toPattern, String toReplacement, Pattern fromPattern, String fromReplacement) {
        this.m_toPattern = toPattern;
        this.m_toReplacement = toReplacement;
        this.m_fromPattern = fromPattern;
        this.m_fromReplacement = fromReplacement;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TO_PATTERN, (String)this.m_toPattern.toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TO_REPLACEMENT, (String)this.m_toReplacement);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FROM_PATTERN, (String)this.m_fromPattern.toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FROM_REPLACEMENT, (String)this.m_fromReplacement);
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final Pattern getFromPattern() {
        return this.m_fromPattern;
    }

    public final String getFromReplacement() {
        return this.m_fromReplacement;
    }

    public final Pattern getToPattern() {
        return this.m_toPattern;
    }

    public final String getToReplacement() {
        return this.m_toReplacement;
    }

    private String transform(String source, Pattern pattern, String replacement, Pattern reversePattern, String reverseReplacement) throws TransformerMismatchException {
        String result = BidirectionalTransformer.replace(source, pattern, replacement);
        if (result == null) {
            return null;
        }
        String reverse = BidirectionalTransformer.replace(result, reversePattern, reverseReplacement);
        if (reverse == null) {
            return null;
        }
        if (source.equals(reverse)) {
            return result;
        }
        throw new TransformerMismatchException(this);
    }

    public String transformFrom(String source) throws TransformerMismatchException {
        return this.transform(source, this.m_fromPattern, this.m_fromReplacement, this.m_toPattern, this.m_toReplacement);
    }

    public String transformTo(String source) throws TransformerMismatchException {
        return this.transform(source, this.m_toPattern, this.m_toReplacement, this.m_fromPattern, this.m_fromReplacement);
    }
}

