/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import org.eclipse.buckminster.core.rmap.model.Matcher;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Locator
extends Matcher {
    public static final String TAG = "locator";
    public static final String ATTR_FAIL_ON_ERROR = "failOnError";
    public static final String ATTR_SEARCH_PATH_REF = "searchPathRef";
    private final String m_searchPath;
    private final boolean m_failOnError;

    public Locator(ResourceMap owner, String pattern, String searchPath) {
        this(owner, pattern, searchPath, true);
    }

    public Locator(ResourceMap owner, String pattern, String searchPath, boolean failOnError) {
        super(owner, pattern);
        this.m_searchPath = searchPath;
        this.m_failOnError = failOnError;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getSearchPath() {
        return this.m_searchPath;
    }

    public boolean isFailOnError() {
        return this.m_failOnError;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SEARCH_PATH_REF, (String)this.m_searchPath);
        if (!this.m_failOnError) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FAIL_ON_ERROR, (String)Boolean.toString(this.m_failOnError));
        }
        super.addAttributes(attrs);
    }
}

