/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Matcher;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.Redirect;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.SearchPathNotFoundException;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap
extends AbstractSaxableElement
implements ISaxable {
    public static final String TAG = "rmap";
    private final ArrayList<Matcher> m_matchers = new ArrayList();
    private final HashMap<String, SearchPath> m_searchPaths = new HashMap();
    private final Map<String, String> m_properties = new ExpandingProperties<String>(null);
    private Documentation m_documentation;
    private final URL m_contextURL;

    public static ResourceMap fromURL(URL url, IConnectContext cctx) throws CoreException {
        IParserFactory pf = CorePlugin.getDefault().getParserFactory();
        IParser<ResourceMap> rmapParser = pf.getResourceMapParser(true);
        InputStream input = null;
        try {
            input = DownloadManager.read((URL)url, (IConnectContext)cctx);
            ResourceMap resourceMap = rmapParser.parse(url.toString(), input);
            return resourceMap;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)input);
        }
    }

    private static IStatus transformToWarning(IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            int idx = children.length;
            while (--idx >= 0) {
                children[idx] = ResourceMap.transformToWarning(children[idx]);
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), children, status.getMessage(), status.getException());
        }
        return status.getSeverity() < 4 ? status : new Status(2, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
    }

    public ResourceMap(URL contextURL) {
        this.m_contextURL = contextURL;
    }

    public void addMatcher(Matcher matcher) {
        this.m_matchers.add(matcher);
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        prefixMappings.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        prefixMappings.put("rm", "http://www.eclipse.org/buckminster/RMap-1.0");
        for (SearchPath searchPath : this.m_searchPaths.values()) {
            searchPath.addPrefixMappings(prefixMappings);
        }
    }

    public void addSearchPath(SearchPath searchPath) {
        this.m_searchPaths.put(searchPath.getName(), searchPath);
    }

    public void clear() {
        this.m_matchers.clear();
        this.m_searchPaths.clear();
        this.m_properties.clear();
        this.m_documentation = null;
    }

    public URL getContextURL() {
        return this.m_contextURL;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    public List<Matcher> getMatchers() {
        return this.m_matchers;
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public Map<String, ? extends Object> getProperties(Map<String, ? extends Object> properties) {
        if (!this.m_properties.isEmpty()) {
            properties = new UnmodifiableMapUnion<String, String>(properties, this.m_properties);
        }
        return properties;
    }

    public SearchPath getSearchPathByReference(String searchPathRef) throws SearchPathNotFoundException {
        SearchPath sp = this.m_searchPaths.get(searchPathRef);
        if (sp == null) {
            throw new SearchPathNotFoundException("reference " + searchPathRef);
        }
        return sp;
    }

    public Collection<SearchPath> getSearchPaths() {
        return this.m_searchPaths.values();
    }

    public void removeMatcher(Matcher matcher) {
        this.m_matchers.remove((Object)matcher);
    }

    public BOMNode resolve(NodeQuery query, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2000);
        ComponentRequest request = query.getComponentRequest();
        MultiStatus problemCollector = new MultiStatus(CorePlugin.getID(), 0, NLS.bind((String)Messages.no_suitable_provider_for_0_was_found_in_resourceMap_1, (Object)request, (Object)this.getContextURL()), null);
        Map<String, ? extends Object> props = query.getProperties();
        if (!this.m_properties.isEmpty()) {
            query = new NodeQuery(query, this.m_properties, false);
            props = query.getProperties();
        }
        String componentName = request.getName();
        for (Matcher matcher : this.m_matchers) {
            if (!matcher.matches(componentName)) continue;
            if (matcher instanceof Redirect) {
                return ((Redirect)matcher).getResourceMap(query).resolve(query, monitor);
            }
            Locator locator = (Locator)matcher;
            try {
                String searchPathRef = locator.getSearchPath();
                searchPathRef = ExpandingProperties.expand(props, searchPathRef, 0);
                SearchPath sp = this.getSearchPathByReference(searchPathRef);
                query.logDecision(ResolverDecisionType.USING_SEARCH_PATH, sp.getName());
                return this.resolve(query, sp, monitor);
            }
            catch (CoreException e) {
                problemCollector.add(e.getStatus());
                if (locator.isFailOnError()) break;
            }
        }
        if (problemCollector.getChildren().length == 0) {
            query.logDecision(ResolverDecisionType.SEARCH_PATH_NOT_FOUND, new Object[]{null});
            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, NLS.bind((String)Messages.Unable_to_find_a_searchPath_for_0, (Object)request), null));
        }
        if (request.isOptional()) {
            query.getContext().addRequestStatus(request, ResourceMap.transformToWarning((IStatus)problemCollector));
            return new UnresolvedNode(new QualifiedDependency(request, query.getRequiredAttributes()));
        }
        throw new CoreException((IStatus)problemCollector);
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        this.toSax(handler, "http://www.eclipse.org/buckminster/RMap-1.0", "rm", this.getDefaultTag());
        handler.endDocument();
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        this.addPrefixMappings(prefixMappings);
        Set<Map.Entry<String, String>> pfxMappings = prefixMappings.entrySet();
        for (Map.Entry<String, String> pfxMapping : pfxMappings) {
            handler.startPrefixMapping(pfxMapping.getKey(), pfxMapping.getValue());
        }
        super.toSax(handler, namespace, prefix, localName);
        for (Map.Entry<String, String> pfxMapping : pfxMappings) {
            handler.endPrefixMapping(pfxMapping.getKey());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(handler, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        SAXEmitter.emitProperties(handler, this.m_properties, namespace, prefix, true, false);
        for (SearchPath searchPath : this.m_searchPaths.values()) {
            searchPath.toSax(handler, namespace, prefix, searchPath.getDefaultTag());
        }
        for (Matcher matcher : this.m_matchers) {
            matcher.toSax(handler, namespace, prefix, matcher.getDefaultTag());
        }
    }

    /*
     * Unable to fully structure code
     */
    private BOMNode resolve(NodeQuery query, SearchPath searchPath, IProgressMonitor monitor) throws CoreException {
        problemCollector = new MultiStatus(CorePlugin.getID(), 4, NLS.bind((String)Messages.No_suitable_provider_for_component_0_was_found_in_searchPath_1, (Object)query.getComponentRequest(), (Object)searchPath.getName()), null);
        noGoodList = new ArrayList<Provider>();
        try {
            first = true;
            while (true) {
                providerMatch = searchPath.getProvider(query, noGoodList, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(first != false ? 1000 : 0)));
                MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
                provider = providerMatch.getProvider();
                cType = providerMatch.getComponentType();
                try {
                    block9: {
                        block8: {
                            node = cType.getResolution(providerMatch, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(first != false ? 1000 : 0)));
                            resolution = node.getResolution();
                            MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
                            filterHandle = new Filter[1];
                            if (resolution.isFilterMatchFor(query, filterHandle)) break block8;
                            decision = query.logDecision(ResolverDecisionType.FILTER_MISMATCH, new Object[]{filterHandle[0]});
                            noGoodList.add(providerMatch.getOriginalProvider());
                            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                            ** GOTO lbl44
                        }
                        cspec = resolution.getCSpec();
                        version = cspec.getVersion();
                        range = query.getVersionRange();
                        if (range == null || provider.getVersionConverterDesc() != null || range.isIncluded(version)) break block9;
                        decision = query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{version, NLS.bind((String)Messages.Not_designated_by_0, (Object)range)});
                        noGoodList.add(providerMatch.getOriginalProvider());
                        problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                        ** GOTO lbl44
                    }
                    cspec.getAttributes(query.getRequiredAttributes());
                    if (version != null && (vm = resolution.getVersionMatch()).getVersion() == null) {
                        node = new ResolvedNode(new Resolution(version, resolution), node.getChildren());
                    }
                    var18_18 = node;
                    return var18_18;
                }
                catch (CoreException e) {
                    decision = query.logDecision(ResolverDecisionType.EXCEPTION, new Object[]{e.getMessage()});
                    problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), (Throwable)e));
                    noGoodList.add(providerMatch.getOriginalProvider());
lbl44:
                    // 3 sources

                    first = false;
                    continue;
                }
                break;
            }
        }
        finally {
            monitor.done();
        }
    }
}

