/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.net.URL;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.MatcherHandler;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapParser;
import org.eclipse.buckminster.core.rmap.parser.SearchPathHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapHandler
extends PropertyManagerHandler {
    private URL m_contextURL;
    private SearchPathHandler m_searchPathHandler;
    private MatcherHandler.LocatorHandler m_locatorHandler;
    private MatcherHandler.RedirectHandler m_redirectHandler;
    private DocumentationHandler m_documentationHandler;
    private ResourceMap m_resourceMap;

    public ResourceMapHandler(AbstractHandler parent) {
        super(parent, "rmap");
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_documentationHandler) {
            this.getResourceMap().setDocumentation(this.m_documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("searchPath".equals(localName)) {
            if (this.m_searchPathHandler == null) {
                this.m_searchPathHandler = new SearchPathHandler((AbstractHandler)this);
            }
            ch = this.m_searchPathHandler;
        } else if ("locator".equals(localName)) {
            if (this.m_locatorHandler == null) {
                this.m_locatorHandler = new MatcherHandler.LocatorHandler((AbstractHandler)this);
            }
            ch = this.m_locatorHandler;
        } else if ("redirect".equals(localName)) {
            if (this.m_redirectHandler == null) {
                this.m_redirectHandler = new MatcherHandler.RedirectHandler((AbstractHandler)this);
            }
            ch = this.m_redirectHandler;
        } else if ("documentation".equals(localName)) {
            if (this.m_documentationHandler == null) {
                this.m_documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.m_documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        ((ResourceMapParser)this.getTopHandler()).setResourceMap(this.getResourceMap());
    }

    public ExpandingProperties<String> getProperties() {
        return (ExpandingProperties)this.getResourceMap().getProperties();
    }

    public ResourceMap getResourceMap() {
        if (this.m_resourceMap == null) {
            this.m_resourceMap = new ResourceMap(this.m_contextURL);
        }
        return this.m_resourceMap;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_resourceMap = null;
    }

    void setContextURL(URL contextURL) {
        this.m_contextURL = contextURL;
    }
}

