/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.impl.AndOrFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.FilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.Messages;
import org.eclipse.buckminster.osgi.filter.impl.NotFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.PresentFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.StringFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.SubstringFilterImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private final String m_filter;
    private final StringBuilder m_sb = new StringBuilder();
    private int m_pos;

    public static Filter parse(String filterString) throws InvalidSyntaxException {
        return new Parser(filterString).internalParse();
    }

    static FilterImpl normalize(List<FilterImpl> operands, int op) {
        int top = operands.size();
        if (top == 1) {
            return operands.get(0);
        }
        int idx = 0;
        while (idx < top) {
            FilterImpl f = operands.get(idx);
            if (f.getOp() == op) {
                FilterImpl[] sfs = f.getFilterImpls();
                operands.remove(idx);
                --top;
                int ndx = 0;
                while (ndx < sfs.length) {
                    FilterImpl nf = sfs[ndx];
                    if (!operands.contains(nf)) {
                        operands.add(nf);
                    }
                    ++ndx;
                }
            }
            ++idx;
        }
        if (top == 1) {
            return operands.get(0);
        }
        Collections.sort(operands);
        ArrayList<Compacter> splits = new ArrayList<Compacter>();
        int reverseOp = op == 7 ? 8 : 7;
        int idx2 = 0;
        while (idx2 < top) {
            Parser.merge(splits, operands.get(idx2), reverseOp);
            ++idx2;
        }
        operands.clear();
        top = splits.size();
        idx2 = 0;
        while (idx2 < top) {
            FilterImpl filter = ((Compacter)splits.get(idx2)).getResultingFilter();
            if (!operands.contains(filter)) {
                operands.add(filter);
            }
            ++idx2;
        }
        top = operands.size();
        if (top == 1) {
            return operands.get(0);
        }
        Collections.sort(operands);
        return new AndOrFilterImpl(op, operands.toArray(new FilterImpl[top]));
    }

    private static void merge(List<Compacter> splits, FilterImpl filterImpl, int op) {
        int top = splits.size();
        int idx = 0;
        while (idx < top) {
            Compacter split = splits.get(idx);
            if (split.merge(filterImpl)) {
                return;
            }
            ++idx;
        }
        splits.add(new Compacter(filterImpl, op));
    }

    private Parser(String filter) {
        this.m_filter = filter;
        this.m_pos = 0;
    }

    private Filter internalParse() throws InvalidSyntaxException {
        try {
            FilterImpl filter = this.parse_filter();
            if (this.m_pos != this.m_filter.length()) {
                throw this.syntaxException(Messages.FILTER_TRAILING_CHARACTERS);
            }
            return filter;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidSyntaxException(NLS.bind((String)Messages.FILTER_PREMATURE_END, (Object)this.m_filter), this.m_filter);
        }
    }

    private FilterImpl parse_and() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>();
        while (c == '(') {
            FilterImpl child = this.parse_filter();
            if (!operands.contains(child)) {
                operands.add(child);
            }
            c = this.m_filter.charAt(this.m_pos);
        }
        return Parser.normalize(operands, 7);
    }

    private String parse_attr() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        int begin = this.m_pos;
        int end = this.m_pos;
        char c = this.m_filter.charAt(begin);
        while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
            ++this.m_pos;
            if (!Character.isWhitespace(c)) {
                end = this.m_pos;
            }
            c = this.m_filter.charAt(this.m_pos);
        }
        if (end == begin) {
            throw this.syntaxException(Messages.FILTER_MISSING_ATTR);
        }
        return this.m_filter.substring(begin, end);
    }

    private FilterImpl parse_filter() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ++this.m_pos;
        FilterImpl filter = this.parse_filtercomp();
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != ')') {
            throw this.syntaxException(Messages.FILTER_MISSING_RIGHTPAREN);
        }
        ++this.m_pos;
        this.skipWhiteSpace();
        return filter;
    }

    private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        switch (c) {
            case '&': {
                ++this.m_pos;
                return this.parse_and();
            }
            case '|': {
                ++this.m_pos;
                return this.parse_or();
            }
            case '!': {
                ++this.m_pos;
                return this.parse_not();
            }
        }
        return this.parse_item();
    }

    private FilterImpl parse_item() throws InvalidSyntaxException {
        String attr = this.parse_attr();
        this.skipWhiteSpace();
        char c2 = this.m_filter.charAt(this.m_pos + 1);
        switch (this.m_filter.charAt(this.m_pos)) {
            case '~': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(2, attr, this.parse_value());
            }
            case '>': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(3, attr, this.parse_value());
            }
            case '<': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(4, attr, this.parse_value());
            }
            case '=': {
                if (c2 == '*') {
                    int oldpos = this.m_pos;
                    this.m_pos += 2;
                    this.skipWhiteSpace();
                    if (this.m_filter.charAt(this.m_pos) == ')') {
                        return new PresentFilterImpl(attr);
                    }
                    this.m_pos = oldpos;
                }
                ++this.m_pos;
                Object string = this.parse_substring();
                return string instanceof String ? new StringFilterImpl(1, attr, (String)string) : new SubstringFilterImpl(attr, (String[])string);
            }
        }
        throw this.syntaxException(Messages.FILTER_INVALID_OPERATOR);
    }

    private FilterImpl parse_not() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        FilterImpl child = this.parse_filter();
        return child.getOp() == 9 ? ((NotFilterImpl)child).getFilter() : new NotFilterImpl(child);
    }

    private FilterImpl parse_or() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>();
        while (c == '(') {
            FilterImpl child = this.parse_filter();
            operands.add(child);
            c = this.m_filter.charAt(this.m_pos);
        }
        return Parser.normalize(operands, 8);
    }

    private Object parse_substring() throws InvalidSyntaxException {
        String single;
        ArrayList<String> operands = null;
        this.m_sb.setLength(0);
        block6: while (true) {
            char c = this.m_filter.charAt(this.m_pos);
            switch (c) {
                case ')': {
                    if (this.m_sb.length() <= 0) break block6;
                    String val = this.m_sb.toString();
                    if (operands == null) {
                        return val;
                    }
                    operands.add(val);
                    break block6;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '*': {
                    if (operands == null) {
                        operands = new ArrayList<String>();
                    }
                    if (this.m_sb.length() > 0) {
                        operands.add(this.m_sb.toString());
                        this.m_sb.setLength(0);
                    }
                    operands.add(null);
                    ++this.m_pos;
                    continue block6;
                }
                case '\\': {
                    c = this.m_filter.charAt(++this.m_pos);
                }
                default: {
                    this.m_sb.append(c);
                    ++this.m_pos;
                    continue block6;
                }
            }
            break;
        }
        if (operands == null) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        int size = operands.size();
        if (size == 1 && (single = (String)operands.get(0)) != null) {
            return single;
        }
        return operands.toArray(new String[size]);
    }

    private String parse_value() throws InvalidSyntaxException {
        this.m_sb.setLength(0);
        block5: while (true) {
            char c = this.m_filter.charAt(this.m_pos);
            switch (c) {
                case ')': {
                    break block5;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '\\': {
                    c = this.m_filter.charAt(++this.m_pos);
                }
                default: {
                    this.m_sb.append(c);
                    ++this.m_pos;
                    continue block5;
                }
            }
            break;
        }
        int len = this.m_sb.length();
        while (len > 0 && this.m_sb.charAt(len - 1) <= ' ') {
            --len;
        }
        if (len == 0) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        this.m_sb.setLength(len);
        return this.m_sb.toString();
    }

    private void skipWhiteSpace() {
        int top = this.m_filter.length();
        while (this.m_pos < top && Character.isWhitespace(this.m_filter.charAt(this.m_pos))) {
            ++this.m_pos;
        }
    }

    private InvalidSyntaxException syntaxException(String msg) {
        return new InvalidSyntaxException(NLS.bind((String)msg, (Object)this.m_filter, (Object)this.m_pos), this.m_filter);
    }

    private static class Compacter {
        private FilterImpl m_base;
        private List<FilterImpl> m_parts;
        private int m_op;

        Compacter(FilterImpl base, int op) {
            this.m_base = base;
            this.m_op = op;
        }

        FilterImpl getResultingFilter() {
            if (this.m_parts == null) {
                return this.m_base;
            }
            int partsOp = this.m_op == 7 ? 8 : 7;
            return this.m_base.addFilter(Parser.normalize(this.m_parts, partsOp), this.m_op);
        }

        boolean merge(FilterImpl b) {
            FilterImpl bf;
            int bidx;
            FilterImpl[] aArr = this.m_base.getOp() == this.m_op ? this.m_base.getFilterImpls() : new FilterImpl[]{this.m_base};
            FilterImpl[] bArr = b.getOp() == this.m_op ? b.getFilterImpls() : new FilterImpl[]{b};
            ArrayList<FilterImpl> common = null;
            ArrayList<FilterImpl> onlyA = null;
            int atop = aArr.length;
            int btop = bArr.length;
            int aidx = 0;
            while (aidx < atop) {
                FilterImpl af = aArr[aidx];
                bidx = 0;
                while (bidx < btop) {
                    bf = bArr[bidx];
                    if (af.equals(bf)) {
                        if (common == null) {
                            common = new ArrayList<FilterImpl>();
                        }
                        common.add(af);
                        break;
                    }
                    ++bidx;
                }
                if (bidx == btop) {
                    if (onlyA == null) {
                        onlyA = new ArrayList<FilterImpl>();
                    }
                    onlyA.add(af);
                }
                ++aidx;
            }
            if (common == null) {
                return false;
            }
            if (onlyA == null && this.m_parts == null) {
                return true;
            }
            ArrayList<FilterImpl> onlyB = null;
            bidx = 0;
            while (bidx < btop) {
                bf = bArr[bidx];
                aidx = 0;
                while (aidx < atop) {
                    if (bf.equals(aArr[aidx])) break;
                    ++aidx;
                }
                if (aidx == atop) {
                    if (onlyB == null) {
                        onlyB = new ArrayList<FilterImpl>();
                    }
                    onlyB.add(bf);
                }
                ++bidx;
            }
            if (onlyB == null && this.m_parts == null) {
                this.m_base = b;
                return true;
            }
            if (this.m_parts == null) {
                this.m_parts = new ArrayList<FilterImpl>();
            }
            if (onlyA != null) {
                this.m_base = Parser.normalize((List<FilterImpl>)common, this.m_op);
                FilterImpl af = Parser.normalize(onlyA, this.m_op);
                if (!this.m_parts.contains(af)) {
                    this.m_parts.add(af);
                }
            }
            if (!this.m_parts.contains(bf = Parser.normalize(onlyB, this.m_op))) {
                this.m_parts.add(bf);
            }
            return true;
        }
    }
}

