/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.psf.extension;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.ReferenceInfo;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.team.psf.PSF;
import org.eclipse.buckminster.team.psf.Project;
import org.eclipse.buckminster.team.psf.RepositoryProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSFProvider
extends Provider {
    public static final String BM_PFS_PROVIDER_NS = "http://www.eclipse.org/buckminster/PSFProvider-1.0";
    public static final String BM_PFS_PROVIDER_PREFIX = "psf";
    public static final String ATTR_PSF_FILE = "psfFile";
    private final String psfFile;

    public PSFProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypeIDs, VersionConverterDesc versionConverterDesc, Format uri, Format digest, String digestAlgorithm, Filter resolutionFilter, boolean mutable, boolean source, URIMatcher uriMatcher, Documentation documentation, String pfsFile) {
        super(searchPath, remoteReaderType, componentTypeIDs, versionConverterDesc, uri, digest, digestAlgorithm, resolutionFilter, mutable, source, uriMatcher, documentation);
        this.psfFile = pfsFile;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", "psf:PDEMapProvider");
        if (this.psfFile != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PSF_FILE, (String)this.psfFile);
        }
    }

    private void cachePSF(Map<UUID, Object> userCache, PSF psf) {
        userCache.put(this.getId(), psf);
    }

    public ProviderMatch findMatch(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 100);
        try {
            URI providerURI = URI.createURI((String)this.getURI(query.getProperties()));
            ProviderScore score = query.getProviderScore(this.isMutable(), this.hasSource());
            if (score == ProviderScore.REJECTED) {
                String msg = NLS.bind((String)"Provider {0} for {1} score_below_treshold", (Object)this.getReaderTypeId(), (Object)providerURI);
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, msg, null));
                return null;
            }
            PSF psf = this.getPSF(query, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            if (psf == null) {
                return null;
            }
            ComponentRequest cr = query.getComponentRequest();
            ProviderMatch found = null;
            for (RepositoryProvider provider : psf.getProviders()) {
                IReaderType rt = AbstractReaderType.getTypeForRepositoryProvider((String)provider.getId());
                if (rt == null) {
                    query.logDecision(ResolverDecisionType.READER_TYPE_NOT_FOUND, new Object[]{provider.getId()});
                    continue;
                }
                for (Project project : provider.getProjects()) {
                    ProviderMatch candidate;
                    String ref = project.getReference();
                    ReferenceInfo refInfo = rt.extractReferenceInfo(ref);
                    String repoLocation = refInfo.getRepositoryLocation();
                    if (!cr.getProjectName().equals(refInfo.getProjectName()) && !cr.getName().equals(refInfo.getProjectName())) {
                        char endChar;
                        boolean startsWithName;
                        int idx = repoLocation.lastIndexOf(47);
                        if (idx < 0) continue;
                        boolean startsWithProjName = repoLocation.indexOf(cr.getProjectName(), ++idx) == idx;
                        boolean bl = startsWithName = repoLocation.indexOf(cr.getName(), idx) == idx;
                        if (!startsWithProjName && !startsWithName) continue;
                        idx = startsWithProjName ? (idx += cr.getProjectName().length()) : (idx += cr.getName().length());
                        char c = endChar = idx < repoLocation.length() ? repoLocation.charAt(idx) : (char)'\u0000';
                        if (endChar >= '0' && endChar <= '9' || endChar >= 'A' && endChar <= 'Z' || endChar >= 'a' && endChar <= 'z' || endChar == '.') continue;
                    }
                    if (!query.isMatch(refInfo.getSelector())) continue;
                    Format uri = new Format(repoLocation);
                    Provider delegated = new Provider(this.getSearchPath(), rt.getId(), this.getComponentTypeIDs(), this.getVersionConverterDesc(), uri, null, null, this.getResolutionFilter(), this.isMutable(), this.hasSource(), null, null);
                    NodeQuery tmpQuery = query;
                    VersionSelector vs = refInfo.getSelector();
                    if (vs != null && query.getBranchTagPath().length == 0) {
                        ComponentQuery cquery = query.getComponentQuery();
                        ComponentQueryBuilder cqTmp = new ComponentQueryBuilder();
                        cqTmp.initFrom((IComponentQuery)cquery);
                        AdvisorNodeBuilder foundNode = null;
                        for (AdvisorNodeBuilder node : cqTmp.getAdvisoryNodes()) {
                            Filter filter;
                            String matchingType;
                            Pattern pattern = node.getNamePattern();
                            if (pattern != null && !pattern.matcher(cr.getName()).find() || (matchingType = node.getComponentTypeID()) != null && !matchingType.equals(cr.getComponentTypeID()) || (filter = node.getFilter()) != null && !filter.match((Map)query.getContext())) continue;
                            foundNode = node;
                            break;
                        }
                        if (foundNode == null) {
                            foundNode = cqTmp.addAdvisorNode();
                            foundNode.setNamePattern(Pattern.compile(Pattern.quote(cr.getName())));
                        }
                        foundNode.setBranchTagPath(new VersionSelector[]{vs});
                        ResolutionContext tmpContext = new ResolutionContext(cqTmp.createComponentQuery(), query.getResolutionContext());
                        tmpQuery = new NodeQuery((RMContext)tmpContext, query.getQualifiedDependency());
                    }
                    if ((candidate = delegated.findMatch(tmpQuery, problemCollector, monitor)) == null) continue;
                    if (found == null) {
                        found = candidate;
                        continue;
                    }
                    if (found.compareTo(candidate) >= 0) continue;
                    query.logDecision(ResolverDecisionType.MATCH_REJECTED, new Object[]{found.getVersionMatch(), NLS.bind((String)"{0} is a better match", (Object)candidate.getVersionMatch())});
                    found = candidate;
                }
            }
            ProviderMatch providerMatch = found;
            return providerMatch;
        }
        finally {
            monitor.done();
        }
    }

    private PSF getCachedPSF(Map<UUID, Object> userCache) {
        return (PSF)userCache.get(this.getId());
    }

    public PSF getPSF(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        Map userCache;
        monitor.beginTask(null, 700);
        Map map = userCache = query.getContext().getUserCache();
        synchronized (map) {
            PSF pSF;
            PSF psf = this.getCachedPSF(userCache);
            if (psf != null) {
                return psf;
            }
            try {
                VersionSelector[] btPath = query.getBranchTagPath();
                if (btPath.length == 0) {
                    psf = this.getPSF(null, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                } else {
                    CoreException lastException = null;
                    VersionSelector[] versionSelectorArray = btPath;
                    int n = btPath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VersionSelector bt = versionSelectorArray[n2];
                        try {
                            psf = this.getPSF(bt, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                            lastException = null;
                        }
                        catch (CoreException e) {
                            lastException = e;
                        }
                        ++n2;
                    }
                    if (lastException != null) {
                        throw lastException;
                    }
                }
                this.cachePSF(userCache, psf);
                pSF = psf;
            }
            catch (CoreException e) {
                try {
                    problemCollector.add(e.getStatus());
                    Buckminster.getLogger().debug(e.getMessage(), new Object[0]);
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                return null;
            }
            monitor.done();
            return pSF;
        }
    }

    private PSF getPSF(VersionSelector vs, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        ProviderMatch match = new ProviderMatch((Provider)this, CorePlugin.getDefault().getComponentType("unknown"), new VersionMatch(null, vs, -1L, new Date(), null), ProviderScore.GOOD, query);
        IComponentReader reader = match.getReader(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
        IStreamConsumer<PSF> psfReader = new IStreamConsumer<PSF>(){

            public PSF consumeStream(IComponentReader rdr, String streamName, InputStream stream, IProgressMonitor consumerMon) throws CoreException, IOException {
                File tempFile = File.createTempFile("bm-", ".psf");
                try {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(tempFile);
                        IOUtils.copy((InputStream)stream, (OutputStream)out, (IProgressMonitor)consumerMon);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(out);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)out);
                    ResourceSetImpl rs = new ResourceSetImpl();
                    Resource resource = rs.getResource(URI.createFileURI((String)tempFile.getAbsolutePath()), true);
                    EList content = resource.getContents();
                    if (content.size() != 1) {
                        throw BuckminsterException.fromMessage((String)NLS.bind((String)"Unable to parse psf file from {0}", (Object)streamName), (Object[])new Object[0]);
                    }
                    PSF pSF = (PSF)content.get(0);
                    return pSF;
                }
                finally {
                    tempFile.delete();
                }
            }
        };
        try {
            if (reader instanceof ICatalogReader) {
                if (this.psfFile == null) {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)"The psfFile attribute is mandatory when using reader of type {0}", (Object)this.getReaderTypeId()), (Object[])new Object[0]);
                }
                return (PSF)((ICatalogReader)reader).readFile(this.psfFile, (IStreamConsumer)psfReader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            if (this.psfFile != null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)"The psfFile attribute cannot be used in conjunction with reader of type {0}", (Object)this.getReaderTypeId()), (Object[])new Object[0]);
            }
            return (PSF)((IFileReader)reader).readFile((IStreamConsumer)psfReader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }
}

