/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.ui.JobListener;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractCSpecAction
implements IObjectActionDelegate {
    protected IWorkbenchPart m_activePart;
    private CSpec m_selectedComponent;
    private IAdaptable m_selection;

    public CSpec fetchCSpec(IProgressMonitor progressMonitor) {
        if (this.m_selectedComponent != null) {
            return this.m_selectedComponent;
        }
        if (this.m_selection != null) {
            if (WorkspaceInfo.isFullyInitialized() || Job.getJobManager().isSuspended()) {
                this.m_selectedComponent = (CSpec)this.m_selection.getAdapter(CSpec.class);
                progressMonitor.done();
            } else {
                JobListener listener = new JobListener(progressMonitor);
                Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
                this.m_selectedComponent = (CSpec)this.m_selection.getAdapter(CSpec.class);
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
            }
        }
        return this.m_selectedComponent;
    }

    public void run(IAction action) {
        if (this.m_activePart == null) {
            return;
        }
        IWorkbenchPartSite site = this.m_activePart.getSite();
        Shell shell = site.getShell();
        if (this.m_selectedComponent == null) {
            this.run(shell);
        } else {
            this.run(this.m_selectedComponent, shell);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_selectedComponent = null;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() != 1) {
            return;
        }
        Object first = s.getFirstElement();
        if (first instanceof IAdaptable) {
            if (WorkspaceInfo.isFullyInitialized()) {
                this.m_selectedComponent = (CSpec)((IAdaptable)first).getAdapter(CSpec.class);
                action.setEnabled(this.m_selectedComponent != null);
            } else {
                action.setEnabled(true);
            }
            this.m_selection = (IAdaptable)first;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.m_activePart = targetPart;
    }

    protected abstract void run(CSpec var1, Shell var2);

    protected void run(Shell shell) {
        MessageDialog.openInformation((Shell)shell, null, (String)Messages.no_component_is_selected);
    }

    protected void setSelectedComponent(CSpec cspec) {
        this.m_selectedComponent = cspec;
    }
}

