/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.editor.ExternalFileEditorInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SaveRunnable
implements IRunnableWithProgress {
    private final ISaxable m_saxable;
    private final IPath m_location;
    private IEditorInput m_newInput;

    public SaveRunnable(ISaxable saxable, IPath location) {
        this.m_saxable = saxable;
        this.m_location = location;
    }

    public IEditorInput getSavedInput() {
        return this.m_newInput;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IContainer container;
            if (this.m_location.segmentCount() > 1 && (container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.m_location.removeLastSegments(1))) != null) {
                InputStream stream = null;
                try {
                    IFile file = container.getFile((IPath)new Path(this.m_location.lastSegment()));
                    stream = Utils.getInputStream((ISaxable)this.m_saxable);
                    if (file.exists()) {
                        file.setContents(stream, 2, monitor);
                    } else {
                        file.create(stream, false, monitor);
                    }
                    this.m_newInput = new FileEditorInput(file);
                }
                catch (Throwable throwable) {
                    IOUtils.close(stream);
                    throw throwable;
                }
                IOUtils.close((Closeable)stream);
                return;
            }
            FileOutputStream stream = null;
            try {
                File file = this.m_location.toFile();
                stream = new FileOutputStream(file);
                Utils.serialize((ISaxable)this.m_saxable, (OutputStream)stream);
                this.m_newInput = new ExternalFileEditorInput(file);
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
            IOUtils.close((Closeable)stream);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

