/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.ui.internal.LabeledCombo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiUtils {
    public static Button createCheckButton(Composite parent, String key, boolean readOnly, SelectionListener listener) {
        final Button button = new Button(parent, 32);
        if (key != null) {
            button.setText(JFaceResources.getString((String)key));
        }
        button.setFont(parent.getFont());
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        if (readOnly) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    button.setSelection(!button.getSelection());
                }
            });
        }
        return button;
    }

    public static Button createCheckButton(Composite parent, String key, SelectionListener listener) {
        return UiUtils.createCheckButton(parent, key, false, listener);
    }

    public static Label createEmptyLabel(Composite parent) {
        Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return lbl;
    }

    public static Composite createEmptyPanel(Composite parent) {
        return UiUtils.createEmptyPanel(parent, "");
    }

    public static Composite createEmptyPanel(Composite parent, String fictiveStringToSetWidth) {
        Composite hlpComposite = new Composite(parent, 0);
        hlpComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        StackLayout hlpStackLayout = new StackLayout();
        hlpComposite.setLayout((Layout)hlpStackLayout);
        Label hlpEmptyLabel = UiUtils.createEmptyLabel(hlpComposite);
        Text hlpFictiveText = UiUtils.createGridText(hlpComposite, 1, 0, 0);
        hlpFictiveText.setText(fictiveStringToSetWidth);
        hlpStackLayout.topControl = hlpEmptyLabel;
        return hlpComposite;
    }

    public static LabeledCombo createEnumCombo(Composite parent, String labelText, Enum<?>[] values, SelectionListener listener) {
        LabeledCombo combo = new LabeledCombo(parent, 12);
        combo.setLabel(labelText);
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            combo.add(value.toString());
            ++n2;
        }
        combo.select(0);
        if (listener != null) {
            combo.addSelectionListener(listener);
        }
        return combo;
    }

    public static Combo createGridCombo(Composite parent, int horizontalSpan, int widthHint, boolean readOnly, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        style = (readOnly ? 8 : 0) | style;
        Combo combo = new Combo(parent, style);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        combo.setLayoutData((Object)data);
        if (selectionListener != null) {
            combo.addSelectionListener(selectionListener);
        }
        if (modifyListener != null) {
            combo.addModifyListener(modifyListener);
        }
        if (readOnly) {
            ReadOnlyComboSelectionListener readOnlyListener = new ReadOnlyComboSelectionListener();
            combo.addSelectionListener((SelectionListener)readOnlyListener);
            combo.addModifyListener((ModifyListener)readOnlyListener);
        }
        return combo;
    }

    public static Combo createGridCombo(Composite parent, int horizontalSpan, int widthHint, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        return UiUtils.createGridCombo(parent, horizontalSpan, widthHint, false, selectionListener, modifyListener, style);
    }

    public static Combo createGridEnumCombo(Composite parent, int horizontalSpan, int widthHint, Enum<?>[] values, boolean readOnly, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        Combo combo = UiUtils.createGridCombo(parent, horizontalSpan, widthHint, readOnly, selectionListener, modifyListener, style);
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            combo.add(value.toString());
            ++n2;
        }
        combo.select(0);
        return combo;
    }

    public static Combo createGridEnumCombo(Composite parent, int horizontalSpan, int widthHint, Enum<?>[] values, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        Combo combo = UiUtils.createGridCombo(parent, horizontalSpan, widthHint, false, selectionListener, modifyListener, style);
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            combo.add(value.toString());
            ++n2;
        }
        combo.select(0);
        return combo;
    }

    public static Label createGridLabel(Composite parent, String string, int horizontalSpan, int widthHint, int style) {
        Label lbl = new Label(parent, style);
        GridData data = new GridData(4, 0x1000000, false, false);
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        if (horizontalSpan > 1) {
            data.horizontalSpan = horizontalSpan;
        }
        lbl.setLayoutData((Object)data);
        lbl.setText(string);
        return lbl;
    }

    public static Text createGridLabeledText(Composite parent, String label, int labelCols, int textCols, boolean readOnly, int style, ModifyListener listener) {
        if (labelCols < 1 || textCols < 1) {
            throw new IllegalArgumentException();
        }
        final Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, labelCols, 1));
        lbl.setText(label);
        Text text = new Text(parent, (readOnly ? 8 : 0) | 0x800 | style | style){

            public void setEnabled(boolean flag) {
                lbl.setEnabled(flag);
                super.setEnabled(flag);
            }

            protected void checkSubclass() {
            }
        };
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, textCols, 1));
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Text createGridText(Composite parent, int horizontalSpan, int widthHint, boolean readOnly, int style) {
        Text text = UiUtils.createNoBorderGridText(parent, horizontalSpan, widthHint, (readOnly ? 8 : 0) | 0x800 | style, null);
        if (readOnly) {
            text.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return text;
    }

    public static Text createGridText(Composite parent, int horizontalSpan, int widthHint, boolean readOnly, int style, ModifyListener listener) {
        Text text = UiUtils.createNoBorderGridText(parent, horizontalSpan, widthHint, (readOnly ? 8 : 0) | 0x800 | style, listener);
        if (readOnly) {
            text.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return text;
    }

    public static Text createGridText(Composite parent, int horizontalSpan, int widthHint, int style) {
        return UiUtils.createNoBorderGridText(parent, horizontalSpan, widthHint, 0x800 | style, null);
    }

    public static Text createGridText(Composite parent, int horizontalSpan, int widthHint, int style, ModifyListener listener) {
        return UiUtils.createNoBorderGridText(parent, horizontalSpan, widthHint, 0x800 | style, listener);
    }

    public static Text createLabeledText(Composite parent, String label, boolean readOnly, int style) {
        return UiUtils.createGridLabeledText(parent, label, 1, 1, readOnly, style, null);
    }

    public static Text createLabeledText(Composite parent, String label, boolean readOnly, int style, ModifyListener listener) {
        return UiUtils.createGridLabeledText(parent, label, 1, 1, readOnly, style, listener);
    }

    public static ListViewer createListViewer(Composite c, String[] lines, Font font, int maxHeightHintInLines, int maxWidthInChars) {
        ListViewer lv = new ListViewer(c, 2816);
        List l = lv.getList();
        l.setFont(font);
        int maxWidthSeen = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > maxWidthSeen) {
                maxWidthSeen = s.length();
            }
            l.add(s);
            ++n2;
        }
        GridData gd = new GridData(1808);
        gd.heightHint = l.getItemHeight() * (lines.length < maxHeightHintInLines ? lines.length : maxHeightHintInLines);
        GC gc = new GC((Drawable)l);
        int avgCharWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        gd.widthHint = avgCharWidth * (maxWidthSeen < maxWidthInChars ? maxWidthSeen : maxWidthInChars);
        l.setLayoutData((Object)gd);
        return lv;
    }

    public static Text createNoBorderGridText(Composite parent, int horizontalSpan, int widthHint, int style, ModifyListener listener) {
        Text text = new Text(parent, style);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Button createPushButton(Composite parent, String key, SelectionListener listener) {
        Button button = new Button(parent, 8);
        if (key != null) {
            button.setText(JFaceResources.getString((String)key));
        }
        button.setFont(parent.getFont());
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Object nvl(Object arg0, Object arg1) {
        return arg0 != null ? arg0 : arg1;
    }

    public static void openError(Shell shell, String title, Throwable t) {
        CoreException c = BuckminsterException.wrap((Throwable)t);
        ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)c.getStatus());
    }

    public static void setChildrenVisible(Composite composite, boolean visible) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setVisible(visible);
            ++n2;
        }
    }

    public static void setEnabledRecursively(Control c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UiUtils.setEnabledRecursively(child, enabled);
                ++n2;
            }
        }
    }

    public static void setExpandedRecursively(Object treeOrTreeItem, boolean expand) {
        TreeItem[] tia = treeOrTreeItem instanceof Tree ? ((Tree)treeOrTreeItem).getItems() : new TreeItem[]{(TreeItem)treeOrTreeItem};
        TreeItem[] treeItemArray = tia;
        int n = tia.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            ti.setExpanded(expand);
            TreeItem[] treeItemArray2 = ti.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                UiUtils.setExpandedRecursively(child, expand);
                ++n4;
            }
            ++n2;
        }
    }

    public static String trimmedValue(String string) {
        String value = null;
        if (string != null && (value = string.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public static String trimmedValue(Text text) {
        String value = null;
        if (text != null && (value = text.getText().trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static class ReadOnlyComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        SortedMap<Integer, Integer> m_lastSelectionIndexes = new TreeMap<Integer, Integer>();

        ReadOnlyComboSelectionListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.m_lastSelectionIndexes.put(e.time, ((Combo)e.widget).getSelectionIndex());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Integer timeInteger = e.time;
            if (this.m_lastSelectionIndexes.get(timeInteger) != null) {
                this.m_lastSelectionIndexes.remove(timeInteger);
            }
            int lastSelectionIndex = 0;
            Integer lastTimeInteger = null;
            try {
                lastTimeInteger = this.m_lastSelectionIndexes.lastKey();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (lastTimeInteger != null) {
                lastSelectionIndex = (Integer)this.m_lastSelectionIndexes.get(lastTimeInteger);
            }
            ((Combo)e.widget).select(lastSelectionIndex);
        }
    }
}

