/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.actions.AbstractOPMLAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class ExportOPMLAction
extends AbstractOPMLAction {
    protected void run(OPML opml, Shell shell) {
        URI fileURI;
        FileDialog saveAs = new FileDialog(this.getShell(), 8192);
        saveAs.setFileName("component.opml");
        String path = saveAs.open();
        if (path == null) {
            return;
        }
        try {
            fileURI = new URI("file", path, null);
        }
        catch (URISyntaxException e) {
            this.showError(Messages.bad_file_name, Messages.the_entered_file_name_is_not_valid, e);
            return;
        }
        File file = new File(fileURI);
        try {
            if (!file.createNewFile() && !this.showConfirm(Messages.confirm_overwrite, NLS.bind((String)Messages.the_file_0_already_exists_overwrite_question, (Object)file.toString()))) {
                return;
            }
        }
        catch (IOException e) {
            this.showError(Messages.could_not_create_file, Messages.an_error_occured_when_creating_the_file, e);
            return;
        }
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            PrintWriter writer = new PrintWriter(stream);
            Utils.serialize((ISaxable)opml, (OutputStream)stream);
            writer.close();
        }
        catch (FileNotFoundException e) {
            this.showError(Messages.write_error, Messages.error_while_opening_file_for_writing, e);
        }
        catch (SAXException e) {
            this.showError(Messages.opml_format_error, Messages.internal_problem_when_generating_opml_xml, e);
        }
    }
}

