/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.adapters;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.buckminster.generic.ui.actions.IBrowseable;
import org.eclipse.buckminster.generic.ui.actions.IBrowseableFeed;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.OutlineType;
import org.eclipse.buckminster.opml.model.Outline;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;

public class BrowseableAdapterFactory
implements IAdapterFactory {
    private static Class[] s_supported = new Class[]{IBrowseable.class, IBrowseableFeed.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IOutline outline = null;
        if (adaptableObject instanceof IAdaptable) {
            outline = (IOutline)((IAdaptable)adaptableObject).getAdapter(Outline.class);
        }
        if (outline == null && adaptableObject instanceof IOutline) {
            outline = (IOutline)adaptableObject;
        }
        if (outline != null) {
            URL url = null;
            URI uri = null;
            Class<IBrowseable> returnClass = null;
            if (adapterType.isAssignableFrom(IBrowseable.class)) {
                returnClass = IBrowseable.class;
                uri = outline.getType() == OutlineType.LINK ? outline.getUrl() : outline.getHtmlUrl();
            } else if (adapterType.isAssignableFrom(IBrowseableFeed.class)) {
                returnClass = IBrowseableFeed.class;
                uri = outline.getXmlUrl();
            }
            if (uri == null) {
                return null;
            }
            try {
                url = new URL(uri.toString());
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (returnClass == IBrowseable.class) {
                return new BrowseableURL(uri, url, outline.getText(), outline.getTitle());
            }
            if (returnClass == IBrowseableFeed.class) {
                return new BrowseableFeedURL(uri, url, outline.getText(), outline.getTitle());
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return s_supported;
    }

    public static class BrowseableFeedURL
    extends BrowseableURL
    implements IBrowseableFeed {
        public BrowseableFeedURL(URI uri, URL url, String name, String tooltip) {
            super(uri, url, name, tooltip);
        }
    }

    public static class BrowseableURL
    implements IBrowseable {
        private final URI m_uri;
        private final URL m_url;
        private String m_name;
        private String m_tooltip;

        BrowseableURL(URI uri, URL url, String name, String tooltip) {
            this.m_uri = uri;
            this.m_url = url;
            this.m_name = name;
            this.m_tooltip = tooltip;
        }

        public URI getBrowseableURI() {
            return this.m_uri;
        }

        public URL getBrowseableURL() {
            return this.m_url;
        }

        public String getName() {
            return this.m_name;
        }

        public String getTooltip() {
            return this.m_tooltip;
        }
    }
}

