/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.adapters;

import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.opml.IOPML;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.opml.model.Outline;
import org.eclipse.buckminster.ui.adapters.OPMLDataNode;
import org.eclipse.buckminster.ui.adapters.OutlineDataNode;
import org.eclipse.buckminster.ui.adapters.ResolutionDataNode;
import org.eclipse.core.runtime.IAdapterFactory;

public class OPMLAdapterFactory
implements IAdapterFactory {
    private static Class[] s_adapterList = new Class[]{OPML.class, OPMLDataNode.class, Outline.class, OutlineDataNode.class, Resolution.class, ResolutionDataNode.class};

    public Object fromOPML(IOPML adapted, Class clazz) {
        if (clazz.isAssignableFrom(OPMLDataNode.class)) {
            return new OPMLDataNode(adapted);
        }
        if (clazz.isAssignableFrom(OPML.class)) {
            return adapted;
        }
        return null;
    }

    public Object fromOPMLDataNode(OPMLDataNode adapted, Class clazz) {
        if (clazz.isAssignableFrom(OPMLDataNode.class)) {
            return adapted;
        }
        if (clazz.isAssignableFrom(OPML.class)) {
            return adapted.getData();
        }
        ITreeParentDataNode parent = adapted.getParent();
        if (parent == null || !(parent instanceof ResolutionDataNode)) {
            return null;
        }
        if (clazz.isAssignableFrom(ResolutionDataNode.class)) {
            return parent;
        }
        if (clazz.isAssignableFrom(Resolution.class)) {
            return parent.getData();
        }
        return null;
    }

    public Object fromOutline(Outline adapted, Class clazz) {
        if (clazz.isAssignableFrom(OutlineDataNode.class)) {
            return new OutlineDataNode((IOutline)adapted);
        }
        if (clazz.isAssignableFrom(Outline.class)) {
            return adapted;
        }
        return null;
    }

    public Object fromOutlineDataNode(OutlineDataNode adapted, Class clazz) {
        if (clazz.isAssignableFrom(OutlineDataNode.class)) {
            return adapted;
        }
        if (clazz.isAssignableFrom(Outline.class)) {
            return adapted.getData();
        }
        ITreeParentDataNode parent = adapted.getParent();
        while (parent != null && !(parent instanceof OPMLDataNode)) {
            parent = parent.getParent();
        }
        if (parent == null || !(parent instanceof OPMLDataNode)) {
            return null;
        }
        if (clazz.isAssignableFrom(OPML.class)) {
            return parent.getData();
        }
        if (clazz.isAssignableFrom(OPMLDataNode.class)) {
            return parent;
        }
        if ((parent = parent.getParent()) == null || !(parent instanceof ResolutionDataNode)) {
            return null;
        }
        if (clazz.isAssignableFrom(ResolutionDataNode.class)) {
            return parent;
        }
        if (clazz.isAssignableFrom(Resolution.class)) {
            return parent.getData();
        }
        return null;
    }

    public Object fromResolution(Resolution adapted, Class clazz) {
        if (clazz.isAssignableFrom(ResolutionDataNode.class)) {
            return new ResolutionDataNode(adapted);
        }
        if (clazz.isAssignableFrom(OPML.class)) {
            return adapted.getOPML();
        }
        if (clazz.isAssignableFrom(OPMLDataNode.class)) {
            OPML opml = adapted.getOPML();
            return opml == null ? null : new OPMLDataNode((IOPML)opml);
        }
        if (clazz.isAssignableFrom(Resolution.class)) {
            return adapted;
        }
        return null;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IOPML) {
            return this.fromOPML((IOPML)adaptableObject, adapterType);
        }
        if (adaptableObject instanceof IOutline) {
            return this.fromOutline((Outline)adaptableObject, adapterType);
        }
        if (adaptableObject instanceof Resolution) {
            return this.fromResolution((Resolution)adaptableObject, adapterType);
        }
        if (adaptableObject instanceof OPMLDataNode) {
            return this.fromOPMLDataNode((OPMLDataNode)((Object)adaptableObject), adapterType);
        }
        if (adaptableObject instanceof OutlineDataNode) {
            return this.fromOutlineDataNode((OutlineDataNode)((Object)adaptableObject), adapterType);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return s_adapterList;
    }
}

