/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.adapters;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.ui.adapters.CSpecDataNode;
import org.eclipse.buckminster.ui.adapters.ResolutionDataNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;

public class ResourceAdapterFactory
implements IAdapterFactory {
    private static Class[] s_adapterList = new Class[]{CSpec.class, CSpecDataNode.class, Resolution.class, ResolutionDataNode.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IResource) {
            CSpec cspec = this.getCSpecFromResource((IResource)adaptableObject);
            if (cspec == null) {
                return null;
            }
            if (adapterType.isAssignableFrom(CSpec.class)) {
                return cspec;
            }
            if (adapterType.isAssignableFrom(CSpecDataNode.class)) {
                return new CSpecDataNode(cspec);
            }
            Resolution r = null;
            try {
                r = WorkspaceInfo.getResolution((ComponentIdentifier)cspec.getComponentIdentifier());
            }
            catch (CoreException e) {
                return null;
            }
            if (r == null) {
                return null;
            }
            if (adapterType.isAssignableFrom(Resolution.class)) {
                return r;
            }
            if (adapterType.isAssignableFrom(ResolutionDataNode.class)) {
                return new ResolutionDataNode(r);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return s_adapterList;
    }

    public CSpec getCSpecFromResource(IResource resource) {
        while (resource != null) {
            try {
                CSpec cspec = WorkspaceInfo.getCSpec((IResource)resource);
                if (cspec != null) {
                    return cspec;
                }
                resource = resource.getParent();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

