/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class AboutDialog
extends Dialog {
    public static final int EXTENSIONS_ID = 1024;
    public static final String EXTENSIONS_LABEL = Messages.extensions;
    private Image m_image = UiPlugin.getImageDescriptor("images/buckminster_logo.png").createImage();
    private ExtensionsDialog m_extensionDialog = new ExtensionsDialog(this.getShell());

    private static String getCoreVersion() {
        Bundle coreBundle = Platform.getBundle((String)"org.eclipse.buckminster.core");
        return coreBundle == null ? null : (String)coreBundle.getHeaders().get("Bundle-Version");
    }

    public AboutDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean close() {
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.m_extensionDialog.open();
                break;
            }
            case 0: {
                this.setReturnCode(buttonId);
                this.close();
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.about_buckminster);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, EXTENSIONS_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = layout.marginHeight;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing += 5;
        composite.setLayout((Layout)layout);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        composite.setBackgroundMode(2);
        Label label = new Label(composite, 0);
        label.setImage(this.m_image);
        Composite bmComposite = new Composite(composite, 0);
        data = new GridData(1808);
        bmComposite.setLayoutData((Object)data);
        layout = new GridLayout(2, false);
        bmComposite.setLayout((Layout)layout);
        UiUtils.createGridLabel(bmComposite, Messages.version_with_colon, 0, 0, 0);
        UiUtils.createGridLabel(bmComposite, TextUtils.notNullString((Object)AboutDialog.getCoreVersion()), 0, 0, 0);
        UiUtils.createGridLabel(bmComposite, Messages.wiki_with_colon, 0, 0, 0);
        Link wiki = new Link(bmComposite, 0);
        wiki.setText("<A>http://wiki.eclipse.org/index.php/BuckminsterWiki</A>");
        wiki.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://wiki.eclipse.org/index.php/Buckminster");
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        return composite;
    }

    class ExtensionsDialog
    extends Dialog {
        private static final String BUCKMINSTER_PREFIX = "org.eclipse.buckminster";
        private TreeViewer m_treeViewer;
        private IExtensionPoint[] m_extensionPoints;

        public ExtensionsDialog(Shell parentShell) {
            super(parentShell);
            IExtensionPoint[] allPoints = Platform.getExtensionRegistry().getExtensionPoints();
            ArrayList<IExtensionPoint> bmPoints = new ArrayList<IExtensionPoint>();
            IExtensionPoint[] iExtensionPointArray = allPoints;
            int n = allPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionPoint extensionPoint = iExtensionPointArray[n2];
                if (extensionPoint.getContributor().getName().startsWith(BUCKMINSTER_PREFIX) && extensionPoint.getConfigurationElements().length > 0) {
                    bmPoints.add(extensionPoint);
                }
                ++n2;
            }
            Collections.sort(bmPoints, new Comparator<IExtensionPoint>(){

                @Override
                public int compare(IExtensionPoint arg0, IExtensionPoint arg1) {
                    return arg0.getUniqueIdentifier().compareToIgnoreCase(arg1.getUniqueIdentifier());
                }
            });
            this.m_extensionPoints = bmPoints.toArray(new IExtensionPoint[0]);
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this.close();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.buckminster_extensions);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            composite.setLayout((Layout)layout);
            Tree tree = new Tree(composite, 2048);
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_treeViewer = new TreeViewer(tree);
            this.m_treeViewer.setContentProvider((IContentProvider)new NavigatorContentProvider());
            this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
            this.m_treeViewer.setInput((Object)this.m_extensionPoints);
            return composite;
        }

        class NavigatorContentProvider
        implements ITreeContentProvider {
            NavigatorContentProvider() {
            }

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IExtensionPoint) {
                    IExtensionPoint extensionPoint = (IExtensionPoint)parentElement;
                    return extensionPoint.getConfigurationElements();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return (IExtensionPoint[])inputElement;
            }

            public Object getParent(Object element) {
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                Object[] children = this.getChildren(element);
                return children == null ? false : children.length > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class NavigatorLabelProvider
        implements ILabelProvider {
            private List<ILabelProviderListener> m_listeners = new ArrayList<ILabelProviderListener>();
            private Image m_point = UiPlugin.getImageDescriptor("icons/extension_obj.gif").createImage();
            private Image m_element = UiPlugin.getImageDescriptor("icons/generic_xml_obj.gif").createImage();

            public void addListener(ILabelProviderListener listener) {
                this.m_listeners.add(listener);
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                if (element instanceof IExtensionPoint) {
                    return this.m_point;
                }
                if (element instanceof IConfigurationElement) {
                    return this.m_element;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IExtensionPoint) {
                    return ((IExtensionPoint)element).getUniqueIdentifier();
                }
                if (element instanceof IConfigurationElement) {
                    IConfigurationElement confElement = (IConfigurationElement)element;
                    return String.valueOf(TextUtils.notNullString((Object)confElement.getAttribute("id"))) + " (" + confElement.getName() + ")";
                }
                return "";
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
                this.m_listeners.remove(listener);
            }
        }
    }
}

