/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dialogs;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.dialogs.Property;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyDialog
extends Dialog {
    private Property m_property = null;
    private boolean m_newProperty = false;
    private Text m_keyText;
    private Text m_valueText;
    private Button m_okButton;

    public PropertyDialog(Shell parent, Property property) {
        super(parent);
        this.m_property = property;
        this.m_newProperty = property == null;
    }

    public Property getProperty() {
        return this.m_property;
    }

    protected void buttonPressed(int buttonId) {
        this.m_property = buttonId == 1 ? null : new Property(this.m_keyText.getText(), this.m_valueText.getText());
        this.setReturnCode(buttonId);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_newProperty) {
            newShell.setText(Messages.new_property);
        } else {
            newShell.setText(Messages.edit_property);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_keyText.notifyListeners(24, new Event());
    }

    protected Control createDialogArea(Composite parent) {
        Composite textComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 7;
        layout.marginWidth = 10;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(768));
        Label label = UiUtils.createGridLabel(textComposite, Messages.key_with_colon, 1, 0, 0);
        this.m_keyText = UiUtils.createGridText(textComposite, 1, 0, 0);
        GridData data = (GridData)this.m_keyText.getLayoutData();
        data.widthHint = 300;
        this.m_keyText.setLayoutData((Object)data);
        if (!this.m_newProperty) {
            label.setEnabled(false);
            this.m_keyText.setEnabled(false);
        }
        UiUtils.createGridLabel(textComposite, Messages.value_with_colon, 1, 0, 0);
        this.m_valueText = UiUtils.createGridText(textComposite, 1, 0, 0);
        this.m_keyText.setText(this.m_property == null ? "" : this.m_property.getKey());
        this.m_valueText.setText(this.m_property == null ? "" : this.m_property.getValue());
        this.m_keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String key = PropertyDialog.this.m_keyText.getText();
                if (key != null && key.length() > 0) {
                    PropertyDialog.this.m_okButton.setEnabled(true);
                } else {
                    PropertyDialog.this.m_okButton.setEnabled(false);
                }
            }
        });
        return textComposite;
    }
}

