/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.dialogs.Property;
import org.eclipse.buckminster.ui.dialogs.PropertyDialog;
import org.eclipse.buckminster.ui.editor.PropertiesModifyEvent;
import org.eclipse.buckminster.ui.editor.PropertiesModifyListener;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends Composite {
    private ArrayList<Property> m_properties;
    private TableViewer m_tableViewer;
    private Button m_newButton;
    private Button m_editButton;
    private Button m_removeButton;
    private final ArrayList<PropertiesModifyListener> m_listeners = new ArrayList();

    public Properties(Composite parent, int style) {
        super(parent, style);
        this.initComposite();
    }

    public void addPropertiesModifyListener(PropertiesModifyListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void fillProperties(Map<String, String> mappedProperties) {
        mappedProperties.clear();
        for (Property prop : this.m_properties) {
            mappedProperties.put(prop.getKey(), prop.getValue());
        }
    }

    public ArrayList<Property> getProperties() {
        return this.m_properties;
    }

    public void refreshList() {
        this.m_tableViewer.setInput(this.m_properties);
    }

    public void removePropertiesModifyListener(PropertiesModifyListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        this.m_tableViewer.getTable().setEnabled(enabled);
        if (enabled) {
            this.m_newButton.setEnabled(true);
            this.enableDisableButtonGroup();
        } else {
            this.m_newButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
        }
    }

    public void setProperties(Map<String, String> mappedProperties) {
        this.m_properties = new ArrayList();
        for (String key : mappedProperties.keySet()) {
            Property newProp = new Property(key, mappedProperties.get(key));
            try {
                this.addProperty(newProp);
            }
            catch (CoreException e) {
                this.addPropertyErrorDialog(e);
            }
        }
    }

    private void addProperty(Property newProp) throws CoreException {
        String key = newProp.getKey();
        int idx = -1;
        for (Property prop : this.m_properties) {
            if (prop.getKey().compareTo(key) == 0) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.duplicity_of_key_0, (Object)key), (Object[])new Object[0]);
            }
            if (prop.getKey().compareTo(key) <= 0) continue;
            idx = this.m_properties.indexOf(prop);
            break;
        }
        if (idx >= 0) {
            this.m_properties.add(idx, newProp);
        } else {
            this.m_properties.add(newProp);
        }
    }

    private void addPropertyErrorDialog(Throwable e) {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.error, (String)NLS.bind((String)Messages.a_0_property_will_not_be_added, (Object)e.getMessage()));
    }

    private void createButtonBox(Composite parent) {
        Composite buttonBox = new Composite(parent, 0);
        buttonBox.setLayout((Layout)new FillLayout(512));
        buttonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_newButton = UiUtils.createPushButton(buttonBox, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Properties.this.newProperty();
            }
        });
        this.m_editButton = UiUtils.createPushButton(buttonBox, Messages.edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Properties.this.editProperty();
            }
        });
        this.m_removeButton = UiUtils.createPushButton(buttonBox, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Properties.this.removeProperty();
            }
        });
        this.enableDisableButtonGroup();
    }

    private void editProperty() {
        PropertyDialog dialog = new PropertyDialog(this.getShell(), this.getSelectedProperty());
        int idx = this.m_tableViewer.getTable().getSelectionIndex();
        if (dialog.open() == 0) {
            this.m_properties.set(idx, dialog.getProperty());
            this.notifyListeners();
            this.refreshList();
        }
    }

    private void enableDisableButtonGroup() {
        boolean enable = false;
        if (this.m_tableViewer.getTable().getSelectionIndex() >= 0) {
            enable = true;
        }
        this.m_editButton.setEnabled(enable);
        this.m_removeButton.setEnabled(enable);
    }

    private Property getSelectedProperty() {
        int idx = this.m_tableViewer.getTable().getSelectionIndex();
        return idx >= 0 ? (Property)this.m_tableViewer.getElementAt(idx) : null;
    }

    private void initComposite() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Table table = new Table((Composite)this, 68356);
        table.setHeaderVisible(false);
        String[] columnNames = new String[]{Messages.key, Messages.value};
        int[] columnWeights = new int[]{5, 15};
        table.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int idx = 0;
        while (idx < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384, idx);
            tableColumn.setText(columnNames[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
            ++idx;
        }
        table.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.m_tableViewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.m_tableViewer.setInput(this.m_properties);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Properties.this.enableDisableButtonGroup();
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (Properties.this.m_tableViewer.getTable().getSelectionIndex() >= 0) {
                    Properties.this.editProperty();
                }
            }
        });
        this.createButtonBox(this);
    }

    private void newProperty() {
        PropertyDialog dialog = new PropertyDialog(this.getShell(), null);
        if (dialog.open() == 0) {
            try {
                this.addProperty(dialog.getProperty());
                this.notifyListeners();
                this.refreshList();
            }
            catch (CoreException e) {
                this.addPropertyErrorDialog(e);
            }
        }
    }

    private void notifyListeners() {
        PropertiesModifyEvent e = new PropertiesModifyEvent(this);
        for (PropertiesModifyListener listener : this.m_listeners) {
            listener.modifyProperties(e);
        }
    }

    private void removeProperty() {
        Property prop = this.getSelectedProperty();
        this.m_properties.remove(prop);
        this.notifyListeners();
        this.refreshList();
    }

    class PropertiesContentProvider
    implements IStructuredContentProvider {
        PropertiesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return Properties.this.m_properties.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PropertiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            Property prop = (Property)element;
            switch (columnIndex) {
                case 0: {
                    lbl = prop.getKey().toString();
                    break;
                }
                case 1: {
                    lbl = prop.getValue();
                    break;
                }
                default: {
                    lbl = null;
                }
            }
            return lbl;
        }
    }
}

